/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.base.enums.EventTypeEnum;
import io.featureprobe.api.base.enums.MatcherTypeEnum;
import io.featureprobe.api.dao.entity.Event;
import io.featureprobe.api.dao.entity.Metric;
import io.featureprobe.api.dto.EventResponse;
import io.featureprobe.api.dto.MetricConfigResponse;
import io.featureprobe.api.dto.MetricCreateRequest;
import io.featureprobe.api.dto.MetricResponse;
import io.featureprobe.api.mapper.EventMapper;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface MetricMapper {
    public static final MetricMapper INSTANCE = (MetricMapper)Mappers.getMapper(MetricMapper.class);

    @Mapping(target="events", expression="java(toEventResponses(metric.getEvents()))")
    public MetricResponse entityToResponse(Metric var1);

    @Mappings(value={@Mapping(target="eventName", expression="java(toEventName(metric))"), @Mapping(target="eventType", expression="java(toEventType(metric))"), @Mapping(target="metricType", source="type"), @Mapping(target="matcher", expression="java(toEventMatcher(metric))"), @Mapping(target="url", expression="java(toEventUrl(metric))"), @Mapping(target="selector", expression="java(toEventSelector(metric))")})
    public MetricConfigResponse entityToConfigResponse(Metric var1);

    @Mappings(value={@Mapping(target="events", expression="java(toEmptyEvents())"), @Mapping(target="type", source="metricType")})
    public void mapEntity(MetricCreateRequest var1, @MappingTarget Metric var2);

    default public Set<EventResponse> toEventResponses(Set<Event> events) {
        return events.stream().map(e -> EventMapper.INSTANCE.entityToResponse((Event)e)).collect(Collectors.toSet());
    }

    default public Set<Event> toEmptyEvents() {
        return new TreeSet<Event>();
    }

    default public String toEventName(Metric metric) {
        if (CollectionUtils.isEmpty((Collection)metric.getEvents())) {
            return null;
        }
        String eventName = "";
        for (Event event : metric.getEvents()) {
            if (EventTypeEnum.CLICK.equals(event.getType())) {
                return event.getName();
            }
            eventName = event.getName();
        }
        return eventName;
    }

    default public EventTypeEnum toEventType(Metric metric) {
        if (CollectionUtils.isEmpty((Collection)metric.getEvents())) {
            return null;
        }
        EventTypeEnum eventType = EventTypeEnum.CUSTOM;
        for (Event event : metric.getEvents()) {
            if (EventTypeEnum.CLICK.equals(event.getType())) {
                return event.getType();
            }
            eventType = event.getType();
        }
        return eventType;
    }

    default public MatcherTypeEnum toEventMatcher(Metric metric) {
        if (CollectionUtils.isEmpty((Collection)metric.getEvents())) {
            return null;
        }
        return ((Event)metric.getEvents().iterator().next()).getMatcher();
    }

    default public String toEventUrl(Metric metric) {
        if (CollectionUtils.isEmpty((Collection)metric.getEvents())) {
            return null;
        }
        return ((Event)metric.getEvents().iterator().next()).getUrl();
    }

    default public String toEventSelector(Metric metric) {
        if (CollectionUtils.isEmpty((Collection)metric.getEvents())) {
            return null;
        }
        for (Event event : metric.getEvents()) {
            if (!EventTypeEnum.CLICK.equals(event.getType())) continue;
            return event.getSelector();
        }
        return null;
    }
}

