/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.dao.entity.Segment;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dto.SegmentCreateRequest;
import io.featureprobe.api.dto.SegmentPublishRequest;
import io.featureprobe.api.dto.SegmentResponse;
import io.featureprobe.api.dto.SegmentUpdateRequest;
import io.featureprobe.api.dto.ToggleSegmentResponse;
import io.featureprobe.api.mapper.SegmentMapper;

public class SegmentMapperImpl
implements SegmentMapper {
    @Override
    public Segment requestToEntity(SegmentCreateRequest createRequest) {
        if (createRequest == null) {
            return null;
        }
        Segment.SegmentBuilder segment = Segment.builder();
        segment.name(createRequest.getName());
        segment.key(createRequest.getKey());
        segment.description(createRequest.getDescription());
        return segment.build();
    }

    @Override
    public SegmentResponse entityToResponse(Segment segment) {
        if (segment == null) {
            return null;
        }
        SegmentResponse segmentResponse = new SegmentResponse();
        segmentResponse.setName(segment.getName());
        segmentResponse.setKey(segment.getKey());
        segmentResponse.setDescription(segment.getDescription());
        segmentResponse.setProjectKey(segment.getProjectKey());
        segmentResponse.setCreatedTime(segment.getCreatedTime());
        segmentResponse.setModifiedTime(segment.getModifiedTime());
        segmentResponse.setVersion(segment.getVersion());
        segmentResponse.setRules(this.toSegmentRules(segment.getRules()));
        segmentResponse.setModifiedBy(this.getAccount(segment.getModifiedBy()));
        return segmentResponse;
    }

    @Override
    public ToggleSegmentResponse toggleToToggleSegment(Toggle toggle) {
        if (toggle == null) {
            return null;
        }
        ToggleSegmentResponse toggleSegmentResponse = new ToggleSegmentResponse();
        toggleSegmentResponse.setName(toggle.getName());
        toggleSegmentResponse.setKey(toggle.getKey());
        return toggleSegmentResponse;
    }

    @Override
    public void mapEntity(SegmentUpdateRequest updateRequest, Segment segment) {
        if (updateRequest == null) {
            return;
        }
        if (updateRequest.getName() != null) {
            segment.setName(updateRequest.getName());
        }
        if (updateRequest.getDescription() != null) {
            segment.setDescription(updateRequest.getDescription());
        }
    }

    @Override
    public void mapEntity(SegmentPublishRequest publishRequest, Segment segment) {
        if (publishRequest == null) {
            return;
        }
        segment.setRules(this.toSegmentRulesString(publishRequest.getRules()));
    }
}

