/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.base.model.Variation;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.Tag;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dto.ToggleCreateRequest;
import io.featureprobe.api.dto.ToggleItemResponse;
import io.featureprobe.api.dto.ToggleResponse;
import io.featureprobe.api.dto.ToggleUpdateRequest;
import io.featureprobe.api.mapper.BaseMapper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

@Mapper
public interface ToggleMapper
extends BaseMapper {
    public static final ToggleMapper INSTANCE = (ToggleMapper)Mappers.getMapper(ToggleMapper.class);

    @Mappings(value={@Mapping(target="modifiedBy", expression="java(getAccount(toggle.getModifiedBy()))"), @Mapping(target="tags", ignore=true), @Mapping(target="useDays", expression="java(getUseDays(toggle, deadline))")})
    public ToggleItemResponse entityToItemResponse(Toggle var1, Long var2);

    @Mappings(value={@Mapping(target="variations", expression="java(toVariation(toggle.getVariations()))"), @Mapping(target="tags", expression="java(toTagNames(toggle.getTags()))"), @Mapping(target="modifiedBy", expression="java(getAccount(toggle.getModifiedBy()))"), @Mapping(target="useDays", expression="java(getUseDays(toggle, deadline))")})
    public ToggleResponse entityToResponse(Toggle var1, Long var2);

    default public Long getUseDays(Toggle toggle, Long deadline) {
        long days = (long)Math.floor((System.currentTimeMillis() - toggle.getCreatedTime().getTime()) / 86400000L);
        return !toggle.isPermanent() && days > deadline ? Long.valueOf(days) : null;
    }

    default public Set<String> toTagNames(Set<Tag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return Collections.emptySet();
        }
        return tags.stream().map(Tag::getName).collect(Collectors.toSet());
    }

    default public List<Variation> toVariation(String variation) {
        return JsonMapper.toListObject((String)variation, Variation.class);
    }

    @Mappings(value={@Mapping(target="variations", expression="java(toVariationJson(toggleRequest.getVariations()))"), @Mapping(target="tags", ignore=true)})
    public Toggle requestToEntity(ToggleCreateRequest var1);

    default public String toVariationJson(List<Variation> variations) {
        return JsonMapper.toJSONString(variations);
    }

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    @Mapping(target="tags", ignore=true)
    public void mapEntity(ToggleUpdateRequest var1, @MappingTarget Toggle var2);
}

