/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.featureprobe.api.base.cache.ICache;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.PublishMessage;
import io.featureprobe.api.dao.repository.PublishMessageRepository;
import io.featureprobe.api.dto.SdkKeyResponse;
import io.featureprobe.api.dto.ServerResponse;
import io.featureprobe.api.event.ToggleChangeEvent;
import io.featureprobe.api.server.AbstractCacheServerDataSource;
import io.featureprobe.api.service.BaseServerService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class CacheServerDataSource
extends AbstractCacheServerDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheServerDataSource.class);
    ICache<String, byte[]> cache;
    private PublishMessageRepository publishMessageRepository;
    private BaseServerService baseServerService;
    private ApplicationEventPublisher eventPublisher;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FeatureProbe-Cache-Updater-%d").setPriority(1).build());

    @Override
    public SdkKeyResponse queryAllSdkKeys() throws Exception {
        byte[] bytes = (byte[])this.cache.get((Object)"SDK_KEYS_CACHE_KEY");
        return Objects.isNull(bytes) ? null : (SdkKeyResponse)JsonMapper.toObject((String)new String(bytes), SdkKeyResponse.class);
    }

    @Override
    public ServerResponse queryServerTogglesByServerSdkKey(String serverSdkKey) throws Exception {
        byte[] bytes = (byte[])this.cache.get((Object)serverSdkKey);
        return Objects.isNull(bytes) ? null : (ServerResponse)JsonMapper.toObject((String)new String(bytes), ServerResponse.class);
    }

    @Override
    @PostConstruct
    public void init() {
        StopWatch watcher = new StopWatch();
        watcher.start();
        log.info("FeatureProbe API start initialization cache .");
        List publishMessages = this.publishMessageRepository.findAll((Pageable)PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"})).getContent();
        PublishMessage maxId = CollectionUtils.isNotEmpty((Collection)publishMessages) ? (PublishMessage)publishMessages.get(0) : new PublishMessage(Long.valueOf(0L));
        this.cache.put((Object)"MAX_CHANGE_LOG_ID_CACHE_KEY", (Object)JsonMapper.toJSONString((Object)maxId).getBytes());
        SdkKeyResponse sdkKeyResponse = this.baseServerService.queryAllSdkKeys();
        this.cache.put((Object)"SDK_KEYS_CACHE_KEY", (Object)JsonMapper.toJSONString((Object)sdkKeyResponse).getBytes());
        Map<String, byte[]> allServerToggle = this.baseServerService.queryAllServerToggle();
        this.cache.putAll(allServerToggle);
        watcher.stop();
        log.info("FeatureProbe API initialization cache finished . Time : " + watcher.getTime(TimeUnit.SECONDS) + " s");
        this.scheduler.scheduleAtFixedRate(this::handleChangeLog, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    private void handleChangeLog() {
        try {
            PublishMessage maxPublishMessage = (PublishMessage)JsonMapper.toObject((String)new String((byte[])this.cache.get((Object)"MAX_CHANGE_LOG_ID_CACHE_KEY")), PublishMessage.class);
            List publishMessages = this.publishMessageRepository.findAllByIdGreaterThanOrderByIdAsc(maxPublishMessage.getId().longValue());
            if (CollectionUtils.isNotEmpty((Collection)publishMessages)) {
                this.cache.put((Object)"MAX_CHANGE_LOG_ID_CACHE_KEY", (Object)JsonMapper.toJSONString(publishMessages.get(publishMessages.size() - 1)).getBytes());
                HashMap<String, ChangeLogType> logGroup = new HashMap<String, ChangeLogType>();
                boolean isUpdateSdkKey = false;
                for (PublishMessage publishMessage : publishMessages) {
                    logGroup.put(publishMessage.getServerSdkKey(), publishMessage.getType());
                    if (publishMessage.getType() != ChangeLogType.ADD && publishMessage.getType() != ChangeLogType.DELETE) continue;
                    isUpdateSdkKey = true;
                }
                if (isUpdateSdkKey) {
                    this.cache.put((Object)"SDK_KEYS_CACHE_KEY", (Object)JsonMapper.toJSONString((Object)this.baseServerService.queryAllSdkKeys()).getBytes());
                }
                for (String serverSdkKey : logGroup.keySet()) {
                    this.refreshCache(serverSdkKey, (ChangeLogType)logGroup.get(serverSdkKey));
                }
            }
        }
        catch (Exception e) {
            log.error("Cache update error. ", (Throwable)e);
        }
    }

    private void refreshCache(String serverSdkKey, ChangeLogType type) {
        switch (type) {
            case ADD: 
            case CHANGE: {
                this.cache.put((Object)serverSdkKey, (Object)JsonMapper.toJSONString((Object)this.baseServerService.queryServerTogglesByServerSdkKey(serverSdkKey)).getBytes());
                this.eventPublisher.publishEvent((ApplicationEvent)new ToggleChangeEvent(serverSdkKey, this));
                break;
            }
            case DELETE: {
                this.cache.invalidate((Object)serverSdkKey);
                break;
            }
        }
    }

    @Generated
    public CacheServerDataSource(ICache<String, byte[]> cache, PublishMessageRepository publishMessageRepository, BaseServerService baseServerService, ApplicationEventPublisher eventPublisher) {
        this.cache = cache;
        this.publishMessageRepository = publishMessageRepository;
        this.baseServerService = baseServerService;
        this.eventPublisher = eventPublisher;
    }
}

