/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.dao.entity.Attribute;
import io.featureprobe.api.dao.repository.AttributeRepository;
import io.featureprobe.api.dto.AttributeRequest;
import io.featureprobe.api.dto.AttributeResponse;
import io.featureprobe.api.mapper.AttributeMapper;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttributeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttributeService.class);
    private AttributeRepository attributeRepository;

    @Transactional(rollbackFor={Exception.class})
    public AttributeResponse create(String projectKey, AttributeRequest attributeRequest) {
        Attribute attribute = new Attribute();
        attribute.setProjectKey(projectKey);
        attribute.setKey(attributeRequest.getKey());
        return AttributeMapper.INSTANCE.entityToResponse((Attribute)this.attributeRepository.save((Object)attribute));
    }

    public List<String> queryByProjectKey(String projectKey) {
        List attributes = this.attributeRepository.findByProjectKey(projectKey);
        return attributes.stream().map(Attribute::getKey).collect(Collectors.toList());
    }

    @Generated
    public AttributeService(AttributeRepository attributeRepository) {
        this.attributeRepository = attributeRepository;
    }
}

