/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.featureprobe.sdk.server.model.Toggle;
import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.base.enums.EventTypeEnum;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.model.JSEvent;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.builder.ServerSegmentBuilder;
import io.featureprobe.api.builder.ServerToggleBuilder;
import io.featureprobe.api.dao.entity.Dictionary;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Segment;
import io.featureprobe.api.dao.entity.ServerEventEntity;
import io.featureprobe.api.dao.entity.ServerSegmentEntity;
import io.featureprobe.api.dao.entity.ServerToggleEntity;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.ToggleControlConf;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.DictionaryRepository;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.SegmentRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dao.repository.ToggleControlConfRepository;
import io.featureprobe.api.dao.repository.ToggleRepository;
import io.featureprobe.api.dto.SdkKeyResponse;
import io.featureprobe.api.dto.ServerResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ExcludeTenant
public class BaseServerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseServerService.class);
    private EnvironmentRepository environmentRepository;
    private SegmentRepository segmentRepository;
    private ToggleRepository toggleRepository;
    private TargetingRepository targetingRepository;
    private DictionaryRepository dictionaryRepository;
    private ToggleControlConfRepository toggleControlConfRepository;
    @PersistenceContext
    public EntityManager entityManager;
    public static final String SDK_KEY_DICTIONARY_KEY = "all_sdk_key_map";

    public SdkKeyResponse queryAllSdkKeys() {
        SdkKeyResponse sdkKeyResponse = new SdkKeyResponse();
        List environments = this.environmentRepository.findAllByArchivedAndDeleted(false, false);
        environments.stream().forEach(environment -> sdkKeyResponse.put(environment.getClientSdkKey(), environment.getServerSdkKey()));
        Dictionary dictionary = (Dictionary)this.dictionaryRepository.findByKey(SDK_KEY_DICTIONARY_KEY).orElseThrow(() -> new ResourceNotFoundException(ResourceType.DICTIONARY, SDK_KEY_DICTIONARY_KEY));
        sdkKeyResponse.setVersion(Long.parseLong(dictionary.getValue()));
        return sdkKeyResponse;
    }

    public ServerResponse queryServerTogglesByServerSdkKey(String serverSdkKey) {
        Environment environment = (Environment)this.environmentRepository.findByServerSdkKeyOrClientSdkKey(serverSdkKey, serverSdkKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, serverSdkKey));
        return new ServerResponse(this.queryTogglesBySdkKey(environment.getServerSdkKey()), this.querySegmentsBySdkKey(environment.getServerSdkKey()), this.queryEventsBySdkKey(serverSdkKey), environment.getVersion(), environment.getDebuggerUntilTime());
    }

    public Map<String, byte[]> queryAllServerToggle() {
        List allServerToggle = this.environmentRepository.findAllServerToggle();
        List allServerSegment = this.environmentRepository.findAllServerSegment();
        List allServerEvent = this.environmentRepository.findAllServerEvent();
        return this.buildAllServerToggle(allServerToggle, allServerSegment, allServerEvent);
    }

    private Map<String, byte[]> buildAllServerToggle(List<ServerToggleEntity> allServerToggle, List<ServerSegmentEntity> allServerSegment, List<ServerEventEntity> allServerEvent) {
        HashMap segmentsMap = new HashMap();
        allServerSegment.stream().forEach(serverSegment -> {
            if (segmentsMap.containsKey(this.getServerSegmentUniqueKey((ServerSegmentEntity)serverSegment))) {
                ((List)segmentsMap.get(this.getServerSegmentUniqueKey((ServerSegmentEntity)serverSegment))).add(this.toSegment((ServerSegmentEntity)serverSegment));
            } else {
                ArrayList<Segment> segments = new ArrayList<Segment>();
                segments.add(this.toSegment((ServerSegmentEntity)serverSegment));
                segmentsMap.put(this.getServerSegmentUniqueKey((ServerSegmentEntity)serverSegment), segments);
            }
        });
        HashMap eventMap = new HashMap();
        allServerEvent.stream().filter(e -> EventTypeEnum.PAGE_VIEW.equals(e.getType()) || EventTypeEnum.CLICK.equals(e.getType())).forEach(serverEvent -> {
            if (eventMap.containsKey(serverEvent.getServerSdkKey())) {
                ((List)eventMap.get(serverEvent.getServerSdkKey())).add(this.toEvent((ServerEventEntity)serverEvent));
            } else {
                ArrayList<JSEvent> events = new ArrayList<JSEvent>();
                events.add(this.toEvent((ServerEventEntity)serverEvent));
                eventMap.put(serverEvent.getServerSdkKey(), events);
            }
        });
        HashMap<String, List<io.featureprobe.api.dao.entity.Toggle>> toggleMap = new HashMap<String, List<io.featureprobe.api.dao.entity.Toggle>>();
        HashMap<String, List<Targeting>> targetingMap = new HashMap<String, List<Targeting>>();
        HashMap<String, ServerEnv> serverEnvMap = new HashMap<String, ServerEnv>();
        HashMap<String, List<ToggleControlConf>> controlConfMap = new HashMap<String, List<ToggleControlConf>>();
        this.toggleSplit(toggleMap, targetingMap, serverEnvMap, controlConfMap, allServerToggle);
        HashMap<String, byte[]> allServerResponse = new HashMap<String, byte[]>();
        for (String serverSdkKey : targetingMap.keySet()) {
            List<Segment> segments = segmentsMap.getOrDefault(((ServerEnv)serverEnvMap.get(serverSdkKey)).getServerSegmentUniqueKey(), Collections.emptyList()).stream().filter(BaseServerService.distinctByKey(Segment::uniqueKey)).collect(Collectors.toList());
            List<io.featureprobe.api.dao.entity.Toggle> toggles = toggleMap.getOrDefault(((ServerEnv)serverEnvMap.get(serverSdkKey)).getServerToggleUniqueKey(), Collections.emptyList()).stream().filter(BaseServerService.distinctByKey(io.featureprobe.api.dao.entity.Toggle::uniqueKey)).collect(Collectors.toList());
            List<Targeting> targetingList = targetingMap.getOrDefault(serverSdkKey, Collections.emptyList()).stream().filter(BaseServerService.distinctByKey(Targeting::uniqueKey)).collect(Collectors.toList());
            List<ToggleControlConf> controlConfList = controlConfMap.getOrDefault(serverSdkKey, Collections.emptyList()).stream().filter(BaseServerService.distinctByKey(ToggleControlConf::uniqueKey)).collect(Collectors.toList());
            ServerResponse serverResponse = new ServerResponse(this.buildServerToggles(segments, toggles, targetingList, controlConfList), this.buildServerSegments(segments), eventMap.getOrDefault(serverSdkKey, Collections.emptyList()).stream().filter(BaseServerService.distinctByKey(JSEvent::getName)).collect(Collectors.toList()), ((ServerEnv)serverEnvMap.get(serverSdkKey)).getEnvVersion(), ((ServerEnv)serverEnvMap.get(serverSdkKey)).getDebugUntilTime());
            allServerResponse.put(serverSdkKey, JsonMapper.toJSONString((Object)serverResponse).getBytes());
        }
        return allServerResponse;
    }

    private void toggleSplit(Map<String, List<io.featureprobe.api.dao.entity.Toggle>> toggleMap, Map<String, List<Targeting>> targetingMap, Map<String, ServerEnv> serverEnvMap, Map<String, List<ToggleControlConf>> controlConfMap, List<ServerToggleEntity> allServerToggle) {
        allServerToggle.stream().forEach(serverToggle -> {
            if (toggleMap.containsKey(this.getServerToggleUniqueKey((ServerToggleEntity)serverToggle))) {
                ((List)toggleMap.get(this.getServerToggleUniqueKey((ServerToggleEntity)serverToggle))).add(this.toToggle((ServerToggleEntity)serverToggle));
            } else if (Objects.nonNull(serverToggle.getToggleKey())) {
                ArrayList<io.featureprobe.api.dao.entity.Toggle> toggles = new ArrayList<io.featureprobe.api.dao.entity.Toggle>();
                toggles.add(this.toToggle((ServerToggleEntity)serverToggle));
                toggleMap.put(this.getServerToggleUniqueKey((ServerToggleEntity)serverToggle), toggles);
            }
            if (targetingMap.containsKey(serverToggle.getServerSdkKey()) && Objects.nonNull(serverToggle.getToggleKey())) {
                ((List)targetingMap.get(serverToggle.getServerSdkKey())).add(this.toTargeting((ServerToggleEntity)serverToggle));
            } else {
                ArrayList<Targeting> targetingList = new ArrayList<Targeting>();
                if (Objects.nonNull(serverToggle.getToggleKey())) {
                    targetingList.add(this.toTargeting((ServerToggleEntity)serverToggle));
                }
                targetingMap.put(serverToggle.getServerSdkKey(), targetingList);
            }
            if (!serverEnvMap.containsKey(serverToggle.getServerSdkKey())) {
                serverEnvMap.put(serverToggle.getServerSdkKey(), this.toServerEnv((ServerToggleEntity)serverToggle));
            }
            if (controlConfMap.containsKey(serverToggle.getServerSdkKey())) {
                ((List)controlConfMap.get(serverToggle.getServerSdkKey())).add(this.toControlConf((ServerToggleEntity)serverToggle));
            } else {
                ArrayList<ToggleControlConf> controlConfList = new ArrayList<ToggleControlConf>();
                controlConfList.add(this.toControlConf((ServerToggleEntity)serverToggle));
                controlConfMap.put(serverToggle.getServerSdkKey(), controlConfList);
            }
        });
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private String getServerSegmentUniqueKey(ServerSegmentEntity serverSegment) {
        return serverSegment.getProjectKey() + "$" + serverSegment.getOrganizationId();
    }

    private String getServerToggleUniqueKey(ServerToggleEntity serverToggle) {
        return serverToggle.getProjectKey() + "$" + serverToggle.getOrganizationId();
    }

    private Segment toSegment(ServerSegmentEntity serverSegment) {
        Segment segment = new Segment();
        segment.setKey(serverSegment.getSegmentKey());
        segment.setUniqueKey(serverSegment.getSegmentUniqueKey());
        segment.setVersion(serverSegment.getSegmentVersion());
        segment.setRules(serverSegment.getSegmentRules());
        return segment;
    }

    private io.featureprobe.api.dao.entity.Toggle toToggle(ServerToggleEntity serverToggle) {
        io.featureprobe.api.dao.entity.Toggle toggle = new io.featureprobe.api.dao.entity.Toggle();
        toggle.setProjectKey(serverToggle.getProjectKey());
        toggle.setKey(serverToggle.getToggleKey());
        toggle.setReturnType(serverToggle.getReturnType());
        toggle.setClientAvailability(serverToggle.getClientAvailability());
        return toggle;
    }

    private Targeting toTargeting(ServerToggleEntity serverToggle) {
        Targeting targeting = new Targeting();
        targeting.setToggleKey(serverToggle.getToggleKey());
        targeting.setDisabled(serverToggle.getTargetingDisabled().booleanValue());
        targeting.setVersion(serverToggle.getTargetingVersion());
        targeting.setContent(serverToggle.getTargetingContent());
        targeting.setOrganizationId(serverToggle.getOrganizationId());
        targeting.setProjectKey(serverToggle.getProjectKey());
        targeting.setEnvironmentKey(serverToggle.getEnvKey());
        targeting.setPublishTime(serverToggle.getPublishTime());
        return targeting;
    }

    private ServerEnv toServerEnv(ServerToggleEntity serverToggle) {
        ServerEnv serverEnv = new ServerEnv();
        serverEnv.setEnvVersion(serverToggle.getEnvVersion());
        Long debugUntilTime = Objects.isNull(serverToggle.getDebugUntilTime()) || serverToggle.getDebugUntilTime() == 0L ? null : serverToggle.getDebugUntilTime();
        serverEnv.setDebugUntilTime(debugUntilTime);
        serverEnv.setOrganizationId(serverToggle.getOrganizationId());
        serverEnv.setProjectKey(serverToggle.getProjectKey());
        serverEnv.setEnvKey(serverToggle.getEnvKey());
        return serverEnv;
    }

    private JSEvent toEvent(ServerEventEntity serverEvent) {
        JSEvent event = new JSEvent();
        if (EventTypeEnum.CLICK.equals(serverEvent.getType()) && StringUtils.isBlank((String)serverEvent.getSelector())) {
            event.setType(EventTypeEnum.PAGE_VIEW);
        } else {
            event.setType(serverEvent.getType());
        }
        event.setName(serverEvent.getName());
        event.setMatcher(serverEvent.getMatcher());
        event.setUrl(serverEvent.getUrl());
        event.setSelector(serverEvent.getSelector());
        return event;
    }

    private ToggleControlConf toControlConf(ServerToggleEntity toggleEntity) {
        ToggleControlConf controlConf = new ToggleControlConf();
        controlConf.setOrganizationId(toggleEntity.getOrganizationId());
        controlConf.setProjectKey(toggleEntity.getProjectKey());
        controlConf.setEnvironmentKey(toggleEntity.getEnvKey());
        controlConf.setToggleKey(toggleEntity.getToggleKey());
        controlConf.setTrackAccessEvents(!Objects.isNull(toggleEntity.getTrackAccessEvents()) && toggleEntity.getTrackAccessEvents() != false);
        return controlConf;
    }

    private List<Toggle> queryTogglesBySdkKey(String serverSdkKey) {
        Environment environment = (Environment)this.environmentRepository.findByServerSdkKey(serverSdkKey).get();
        if (Objects.isNull(environment)) {
            return Collections.emptyList();
        }
        List segments = this.segmentRepository.findAllByProjectKeyAndOrganizationIdAndDeleted(environment.getProject().getKey(), environment.getOrganizationId(), false);
        List toggles = this.toggleRepository.findAllByProjectKeyAndOrganizationIdAndArchivedAndDeleted(environment.getProject().getKey(), environment.getOrganizationId(), false, false);
        List targetingList = this.targetingRepository.findAllByProjectKeyAndEnvironmentKeyAndOrganizationIdAndDeleted(environment.getProject().getKey(), environment.getKey(), environment.getOrganizationId(), false);
        List controlConfList = this.toggleControlConfRepository.findByProjectKeyAndEnvironmentKeyAndOrganizationId(environment.getProject().getKey(), environment.getKey(), environment.getOrganizationId());
        return this.buildServerToggles(segments, toggles, targetingList, controlConfList);
    }

    private List<com.featureprobe.sdk.server.model.Segment> querySegmentsBySdkKey(String serverSdkKey) {
        Environment environment = (Environment)this.environmentRepository.findByServerSdkKey(serverSdkKey).get();
        if (Objects.isNull(environment)) {
            return Collections.emptyList();
        }
        List segments = this.segmentRepository.findAllByProjectKeyAndOrganizationIdAndDeleted(environment.getProject().getKey(), environment.getOrganizationId(), false);
        return this.buildServerSegments(segments);
    }

    private List<JSEvent> queryEventsBySdkKey(String serverSdkKey) {
        List serverEventEntities = this.environmentRepository.findAllServerEventBySdkKey(serverSdkKey);
        return serverEventEntities.stream().filter(serverEvent -> EventTypeEnum.PAGE_VIEW.equals(serverEvent.getType()) || EventTypeEnum.CLICK.equals(serverEvent.getType())).filter(BaseServerService.distinctByKey(ServerEventEntity::getName)).map(serverEvent -> this.toEvent((ServerEventEntity)serverEvent)).collect(Collectors.toList());
    }

    private List<com.featureprobe.sdk.server.model.Segment> buildServerSegments(List<Segment> segments) {
        return segments.stream().map(segment -> {
            try {
                return new ServerSegmentBuilder().builder().uniqueId(segment.getUniqueKey()).version(segment.getVersion()).rules(segment.getRules()).build();
            }
            catch (Exception e) {
                log.error("Build server segment failed, unique key: {}, segment key: {}", new Object[]{segment.getUniqueKey(), segment.getKey(), e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<Toggle> buildServerToggles(List<Segment> segments, List<io.featureprobe.api.dao.entity.Toggle> toggles, List<Targeting> targetingList, List<ToggleControlConf> controlConfList) {
        Map targetingByKey = targetingList.stream().collect(Collectors.toMap(Targeting::getToggleKey, Function.identity()));
        Map controlConfByKey = controlConfList.stream().collect(Collectors.toMap(ToggleControlConf::getToggleKey, Function.identity()));
        return toggles.stream().map(toggle -> {
            Targeting targeting = (Targeting)targetingByKey.get(toggle.getKey());
            ToggleControlConf controlConf = (ToggleControlConf)controlConfByKey.get(toggle.getKey());
            try {
                return new ServerToggleBuilder().builder().key(toggle.getKey()).disabled(targeting.isDisabled()).version(targeting.getVersion()).returnType(toggle.getReturnType()).forClient(toggle.getClientAvailability()).rules(targeting.getContent()).trackAccessEvents(!Objects.isNull(controlConf) && controlConf.isTrackAccessEvents()).lastModified(targeting.getPublishTime()).segments(segments.stream().collect(Collectors.toMap(Segment::getKey, Function.identity()))).build();
            }
            catch (Exception e) {
                log.warn("Build server toggle failed, OrganizationId : {}, projectKey:{},  toggle key: {}", new Object[]{toggle.getOrganizationId(), toggle.getProjectKey(), toggle.getKey(), e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public BaseServerService(EnvironmentRepository environmentRepository, SegmentRepository segmentRepository, ToggleRepository toggleRepository, TargetingRepository targetingRepository, DictionaryRepository dictionaryRepository, ToggleControlConfRepository toggleControlConfRepository, EntityManager entityManager) {
        this.environmentRepository = environmentRepository;
        this.segmentRepository = segmentRepository;
        this.toggleRepository = toggleRepository;
        this.targetingRepository = targetingRepository;
        this.dictionaryRepository = dictionaryRepository;
        this.toggleControlConfRepository = toggleControlConfRepository;
        this.entityManager = entityManager;
    }

    class ServerEnv {
        Long envVersion;
        Long debugUntilTime;
        Long organizationId;
        String projectKey;
        String envKey;

        private String getServerSegmentUniqueKey() {
            return this.projectKey + "$" + this.organizationId;
        }

        private String getServerToggleUniqueKey() {
            return this.projectKey + "$" + this.organizationId;
        }

        @Generated
        public ServerEnv() {
        }

        @Generated
        public Long getEnvVersion() {
            return this.envVersion;
        }

        @Generated
        public Long getDebugUntilTime() {
            return this.debugUntilTime;
        }

        @Generated
        public Long getOrganizationId() {
            return this.organizationId;
        }

        @Generated
        public String getProjectKey() {
            return this.projectKey;
        }

        @Generated
        public String getEnvKey() {
            return this.envKey;
        }

        @Generated
        public void setEnvVersion(Long envVersion) {
            this.envVersion = envVersion;
        }

        @Generated
        public void setDebugUntilTime(Long debugUntilTime) {
            this.debugUntilTime = debugUntilTime;
        }

        @Generated
        public void setOrganizationId(Long organizationId) {
            this.organizationId = organizationId;
        }

        @Generated
        public void setProjectKey(String projectKey) {
            this.projectKey = projectKey;
        }

        @Generated
        public void setEnvKey(String envKey) {
            this.envKey = envKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerEnv)) {
                return false;
            }
            ServerEnv other = (ServerEnv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$envVersion = this.getEnvVersion();
            Long other$envVersion = other.getEnvVersion();
            if (this$envVersion == null ? other$envVersion != null : !((Object)this$envVersion).equals(other$envVersion)) {
                return false;
            }
            Long this$debugUntilTime = this.getDebugUntilTime();
            Long other$debugUntilTime = other.getDebugUntilTime();
            if (this$debugUntilTime == null ? other$debugUntilTime != null : !((Object)this$debugUntilTime).equals(other$debugUntilTime)) {
                return false;
            }
            Long this$organizationId = this.getOrganizationId();
            Long other$organizationId = other.getOrganizationId();
            if (this$organizationId == null ? other$organizationId != null : !((Object)this$organizationId).equals(other$organizationId)) {
                return false;
            }
            String this$projectKey = this.getProjectKey();
            String other$projectKey = other.getProjectKey();
            if (this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey)) {
                return false;
            }
            String this$envKey = this.getEnvKey();
            String other$envKey = other.getEnvKey();
            return !(this$envKey == null ? other$envKey != null : !this$envKey.equals(other$envKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerEnv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $envVersion = this.getEnvVersion();
            result = result * 59 + ($envVersion == null ? 43 : ((Object)$envVersion).hashCode());
            Long $debugUntilTime = this.getDebugUntilTime();
            result = result * 59 + ($debugUntilTime == null ? 43 : ((Object)$debugUntilTime).hashCode());
            Long $organizationId = this.getOrganizationId();
            result = result * 59 + ($organizationId == null ? 43 : ((Object)$organizationId).hashCode());
            String $projectKey = this.getProjectKey();
            result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
            String $envKey = this.getEnvKey();
            result = result * 59 + ($envKey == null ? 43 : $envKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseServerService.ServerEnv(envVersion=" + this.getEnvVersion() + ", debugUntilTime=" + this.getDebugUntilTime() + ", organizationId=" + this.getOrganizationId() + ", projectKey=" + this.getProjectKey() + ", envKey=" + this.getEnvKey() + ")";
        }
    }
}

