/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.FeatureProbe;
import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.component.SpringBeanManager;
import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.model.TargetingContent;
import io.featureprobe.api.base.util.KeyGenerateUtil;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Project;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.exception.ResourceOverflowException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.ProjectRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dto.EnvironmentCreateRequest;
import io.featureprobe.api.dto.EnvironmentQueryRequest;
import io.featureprobe.api.dto.EnvironmentResponse;
import io.featureprobe.api.dto.EnvironmentUpdateRequest;
import io.featureprobe.api.mapper.EnvironmentMapper;
import io.featureprobe.api.service.ChangeLogService;
import io.featureprobe.api.service.IncludeArchivedToggleService;
import io.featureprobe.api.service.TargetingService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnvironmentService {
    private EnvironmentRepository environmentRepository;
    private ProjectRepository projectRepository;
    private TargetingRepository targetingRepository;
    private ChangeLogService changeLogService;
    private IncludeArchivedToggleService includeArchivedToggleService;
    private TargetingService targetingService;
    @PersistenceContext
    public EntityManager entityManager;
    private static final String LIMITER_TOGGLE_KEY = "FeatureProbe_env_limiter";

    @Transactional(rollbackFor={Exception.class})
    public EnvironmentResponse create(String projectKey, EnvironmentCreateRequest createRequest) {
        this.validateLimit(projectKey);
        Project project = (Project)this.projectRepository.findByKey(projectKey).get();
        Environment environment = EnvironmentMapper.INSTANCE.requestToEntity(createRequest);
        environment.setServerSdkKey(KeyGenerateUtil.getServerSdkKey());
        environment.setClientSdkKey(KeyGenerateUtil.getClientSdkKey());
        environment.setProject(project);
        this.createEnvironmentTargetingList(projectKey, createRequest.getKey(), createRequest.getCopyFrom());
        this.changeLogService.create(environment, ChangeLogType.ADD);
        return EnvironmentMapper.INSTANCE.entityToResponse((Environment)this.environmentRepository.save((Object)environment));
    }

    @Transactional(rollbackFor={Exception.class})
    public EnvironmentResponse update(String projectKey, String environmentKey, EnvironmentUpdateRequest updateRequest) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, environmentKey));
        if (!StringUtils.equals((CharSequence)environment.getName(), (CharSequence)updateRequest.getName())) {
            this.validateEnvironmentByName(projectKey, updateRequest.getName());
        }
        EnvironmentMapper.INSTANCE.mapEntity(updateRequest, environment);
        if (updateRequest.isResetServerSdk()) {
            environment.setServerSdkKey(KeyGenerateUtil.getServerSdkKey());
        }
        if (updateRequest.isResetClientSdk()) {
            environment.setClientSdkKey(KeyGenerateUtil.getClientSdkKey());
        }
        return EnvironmentMapper.INSTANCE.entityToResponse((Environment)this.environmentRepository.save((Object)environment));
    }

    @Transactional(rollbackFor={Exception.class})
    @Archived
    public EnvironmentResponse offline(String projectKey, String environmentKey) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKeyAndArchived(projectKey, environmentKey, Boolean.valueOf(false)).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, environmentKey));
        this.changeLogService.create(environment, ChangeLogType.DELETE);
        environment.setArchived(true);
        return EnvironmentMapper.INSTANCE.entityToResponse((Environment)this.environmentRepository.save((Object)environment));
    }

    @Transactional(rollbackFor={Exception.class})
    @Archived
    public EnvironmentResponse restore(String projectKey, String environmentKey) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKeyAndArchived(projectKey, environmentKey, Boolean.valueOf(true)).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, environmentKey));
        this.changeLogService.create(environment, ChangeLogType.ADD);
        environment.setArchived(false);
        return EnvironmentMapper.INSTANCE.entityToResponse((Environment)this.environmentRepository.save((Object)environment));
    }

    public EnvironmentResponse query(String projectKey, String environmentKey) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, environmentKey));
        return EnvironmentMapper.INSTANCE.entityToResponse(environment);
    }

    @Archived
    public List<EnvironmentResponse> list(String projectKey, EnvironmentQueryRequest queryRequest) {
        List environments = this.environmentRepository.findAllByProjectKeyAndArchivedOrderByCreatedTimeAsc(projectKey, Boolean.valueOf(queryRequest.isArchived()));
        return environments.stream().map(environment -> EnvironmentMapper.INSTANCE.entityToResponse((Environment)environment)).collect(Collectors.toList());
    }

    private void validateLimit(String projectKey) {
        long total = this.environmentRepository.countByProjectKey(projectKey);
        FPUser user = new FPUser(String.valueOf(TokenHelper.getUserId()));
        user.with("account", TokenHelper.getAccount());
        double limitNum = ((FeatureProbe)SpringBeanManager.getBeanByType(FeatureProbe.class)).numberValue(LIMITER_TOGGLE_KEY, user, -1.0);
        if (limitNum > 0.0 && (double)total >= limitNum) {
            throw new ResourceOverflowException(ResourceType.ENVIRONMENT);
        }
    }

    private List<Targeting> createEnvironmentTargetingList(String projectKey, String environmentKey, String copyFromEnvKey) {
        List<Object> targetingList = StringUtils.isBlank((CharSequence)copyFromEnvKey) ? this.includeArchivedToggleService.findAllByProjectKey(projectKey).stream().map(toggle -> this.createTargetingByToggle((Toggle)toggle, environmentKey)).collect(Collectors.toList()) : this.targetingRepository.findAllByProjectKeyAndEnvironmentKey(projectKey, copyFromEnvKey).stream().map(targeting -> this.copyTargeting(environmentKey, (Targeting)targeting)).collect(Collectors.toList());
        if (targetingList.isEmpty()) {
            return Collections.emptyList();
        }
        this.targetingService.createTargetingEntities(targetingList);
        return targetingList;
    }

    private Targeting copyTargeting(String newEnvironmentKey, Targeting sourceTargeting) {
        Targeting newTargeting = this.createTargeting(sourceTargeting.getProjectKey(), newEnvironmentKey, sourceTargeting.getToggleKey(), sourceTargeting.getContent());
        newTargeting.setDeleted(sourceTargeting.isDeleted());
        newTargeting.setDisabled(sourceTargeting.isDisabled());
        newTargeting.setStatus(sourceTargeting.getStatus());
        return newTargeting;
    }

    private Targeting createTargetingByToggle(Toggle toggle, String environmentKey) {
        String defaultContent = TargetingContent.newDefault((String)toggle.getVariations(), (Integer)toggle.getDisabledServe()).toJson();
        return this.createTargeting(toggle.getProjectKey(), environmentKey, toggle.getKey(), defaultContent);
    }

    private Targeting createTargeting(String projectKey, String environmentKey, String toggleKey, String content) {
        Targeting targeting = new Targeting();
        targeting.setDisabled(true);
        targeting.setDeleted(false);
        targeting.setContent(content);
        targeting.setVersion(Long.valueOf(1L));
        targeting.setProjectKey(projectKey);
        targeting.setToggleKey(toggleKey);
        targeting.setEnvironmentKey(environmentKey);
        targeting.setPublishTime(new Date());
        return targeting;
    }

    private void validateEnvironmentByName(String projectKey, String name) {
        if (this.environmentRepository.existsByProjectKeyAndName(projectKey, name)) {
            throw new ResourceConflictException(ResourceType.ENVIRONMENT);
        }
    }

    @ExcludeTenant
    public String getSdkServerKey(String serverKeyOrClientKey) {
        return ((Environment)this.environmentRepository.findByServerSdkKeyOrClientSdkKey(serverKeyOrClientKey, serverKeyOrClientKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, serverKeyOrClientKey))).getServerSdkKey();
    }

    @Generated
    public EnvironmentService(EnvironmentRepository environmentRepository, ProjectRepository projectRepository, TargetingRepository targetingRepository, ChangeLogService changeLogService, IncludeArchivedToggleService includeArchivedToggleService, TargetingService targetingService, EntityManager entityManager) {
        this.environmentRepository = environmentRepository;
        this.projectRepository = projectRepository;
        this.targetingRepository = targetingRepository;
        this.changeLogService = changeLogService;
        this.includeArchivedToggleService = includeArchivedToggleService;
        this.targetingService = targetingService;
        this.entityManager = entityManager;
    }
}

