/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.db.IncludeDeleted;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.repository.ToggleRepository;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class IncludeArchivedToggleService {
    private ToggleRepository toggleRepository;
    @PersistenceContext
    public EntityManager entityManager;

    @Archived
    public List<Toggle> findAllByProjectKey(String projectKey) {
        return this.toggleRepository.findAllByProjectKey(projectKey);
    }

    @Archived
    @IncludeDeleted
    public void validateIncludeArchivedToggle(String projectKey, ValidateTypeEnum type, String value) {
        switch (type) {
            case KEY: {
                this.validateIncludeArchivedToggleByKey(projectKey, value);
                break;
            }
            case NAME: {
                this.validateIncludeArchivedToggleByName(projectKey, value);
                break;
            }
        }
    }

    @Archived
    public void validateIncludeArchivedToggleByName(String projectKey, String name) {
        if (this.toggleRepository.existsByProjectKeyAndName(projectKey, name)) {
            throw new ResourceConflictException(ResourceType.ENVIRONMENT);
        }
    }

    @Archived
    public void validateIncludeArchivedToggleByKey(String projectKey, String key) {
        if (this.toggleRepository.existsByProjectKeyAndKey(projectKey, key)) {
            throw new ResourceConflictException(ResourceType.ENVIRONMENT);
        }
    }

    @Generated
    public IncludeArchivedToggleService(ToggleRepository toggleRepository, EntityManager entityManager) {
        this.toggleRepository = toggleRepository;
        this.entityManager = entityManager;
    }
}

