/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.db.IncludeDeleted;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.repository.MemberRepository;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MemberIncludeDeletedService {
    private MemberRepository memberRepository;
    @PersistenceContext
    public EntityManager entityManager;

    @IncludeDeleted
    public boolean validateAccountIncludeDeleted(String account) {
        if (this.memberRepository.existsByAccount(account)) {
            throw new ResourceConflictException(ResourceType.MEMBER);
        }
        return true;
    }

    @IncludeDeleted
    public Optional<Member> queryMemberByAccountIncludeDeleted(String account) {
        return this.memberRepository.findByAccount(account);
    }

    @Generated
    public MemberIncludeDeletedService(MemberRepository memberRepository, EntityManager entityManager) {
        this.memberRepository = memberRepository;
        this.entityManager = entityManager;
    }
}

