/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.base.model.PaginationRequest;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.base.util.ToggleContentLimitChecker;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Project;
import io.featureprobe.api.dao.entity.Segment;
import io.featureprobe.api.dao.entity.SegmentVersion;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.TargetingSegment;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dao.entity.ToggleControlConf;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.ProjectRepository;
import io.featureprobe.api.dao.repository.SegmentRepository;
import io.featureprobe.api.dao.repository.SegmentVersionRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dao.repository.TargetingSegmentRepository;
import io.featureprobe.api.dao.repository.ToggleControlConfRepository;
import io.featureprobe.api.dao.repository.ToggleRepository;
import io.featureprobe.api.dao.utils.PageRequestUtil;
import io.featureprobe.api.dto.SegmentCreateRequest;
import io.featureprobe.api.dto.SegmentPublishRequest;
import io.featureprobe.api.dto.SegmentResponse;
import io.featureprobe.api.dto.SegmentSearchRequest;
import io.featureprobe.api.dto.SegmentUpdateRequest;
import io.featureprobe.api.dto.SegmentVersionRequest;
import io.featureprobe.api.dto.SegmentVersionResponse;
import io.featureprobe.api.dto.ToggleSegmentResponse;
import io.featureprobe.api.mapper.SegmentMapper;
import io.featureprobe.api.mapper.SegmentVersionMapper;
import io.featureprobe.api.service.ChangeLogService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SegmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentService.class);
    private SegmentRepository segmentRepository;
    private TargetingSegmentRepository targetingSegmentRepository;
    private TargetingRepository targetingRepository;
    private ToggleRepository toggleRepository;
    private EnvironmentRepository environmentRepository;
    private ProjectRepository projectRepository;
    private SegmentVersionRepository segmentVersionRepository;
    private ToggleControlConfRepository toggleControlConfRepository;
    private ChangeLogService changeLogService;
    @PersistenceContext
    public EntityManager entityManager;

    public Page<SegmentResponse> list(String projectKey, SegmentSearchRequest searchRequest) {
        Specification<Segment> spec = this.buildQuerySpec(projectKey, searchRequest.getKeyword());
        return this.findPagingBySpec(spec, PageRequestUtil.toCreatedTimeDescSortPageable((PaginationRequest)searchRequest));
    }

    public SegmentResponse create(String projectKey, SegmentCreateRequest createRequest) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        this.validateKey(projectKey, createRequest.getKey());
        this.validateName(projectKey, createRequest.getName());
        Segment segment = SegmentMapper.INSTANCE.requestToEntity(createRequest);
        segment.setProjectKey(projectKey);
        segment.setUniqueKey(StringUtils.join((Object[])new String[]{projectKey, "$", createRequest.getKey()}));
        segment.setRules(JsonMapper.toJSONString(Collections.emptyList()));
        segment.setVersion(Long.valueOf(1L));
        this.saveSegmentChangeLog(project);
        Segment savedSegment = (Segment)this.segmentRepository.save((Object)segment);
        this.saveSegmentVersion(this.buildSegmentVersion(savedSegment, null, null));
        return SegmentMapper.INSTANCE.entityToResponse(savedSegment);
    }

    @Transactional(rollbackFor={Exception.class})
    public SegmentResponse update(String projectKey, String segmentKey, SegmentUpdateRequest updateRequest) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        Segment segment = (Segment)this.segmentRepository.findByProjectKeyAndKey(projectKey, segmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.SEGMENT, projectKey + "_" + segmentKey));
        if (!StringUtils.equals((CharSequence)segment.getName(), (CharSequence)updateRequest.getName())) {
            this.validateName(projectKey, updateRequest.getName());
        }
        SegmentMapper.INSTANCE.mapEntity(updateRequest, segment);
        this.saveSegmentChangeLog(project);
        return SegmentMapper.INSTANCE.entityToResponse((Segment)this.segmentRepository.save((Object)segment));
    }

    @Transactional(rollbackFor={Exception.class})
    public SegmentResponse publish(String projectKey, String segmentKey, SegmentPublishRequest publishRequest) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        Segment segment = (Segment)this.segmentRepository.findByProjectKeyAndKey(projectKey, segmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.SEGMENT, projectKey + "_" + segmentKey));
        this.validatePublishConflicts(segment, publishRequest.getBaseVersion());
        SegmentMapper.INSTANCE.mapEntity(publishRequest, segment);
        Long oldVersion = ObjectUtils.isNotEmpty((Object)publishRequest.getBaseVersion()) ? publishRequest.getBaseVersion() : segment.getVersion();
        ToggleContentLimitChecker.validateSize((String)segment.getRules());
        Segment updatedSegment = (Segment)this.segmentRepository.saveAndFlush((Object)segment);
        if (updatedSegment.getVersion() > oldVersion) {
            this.saveSegmentVersion(this.buildSegmentVersion(updatedSegment, publishRequest.getComment(), null));
        }
        this.saveSegmentChangeLog(project);
        return SegmentMapper.INSTANCE.entityToResponse(updatedSegment);
    }

    protected void validatePublishConflicts(Segment segment, Long baseVersion) {
        if (baseVersion != null && segment.getVersion() != null && !segment.getVersion().equals(baseVersion)) {
            throw new OptimisticLockException("publish conflict");
        }
    }

    private void saveSegmentChangeLog(Project project) {
        if (CollectionUtils.isNotEmpty((Collection)project.getEnvironments())) {
            for (Environment environment : project.getEnvironments()) {
                this.changeLogService.create(environment, ChangeLogType.CHANGE);
            }
        }
    }

    public Page<SegmentVersionResponse> versions(String projectKey, String segmentKey, SegmentVersionRequest versionRequest) {
        Specification<SegmentVersion> spec = this.buildVersionsQuerySpec(projectKey, segmentKey);
        Page versions = this.segmentVersionRepository.findAll(spec, PageRequestUtil.toPageable((PaginationRequest)versionRequest, (Sort.Direction)Sort.Direction.DESC, (String)"version"));
        return versions.map(version -> SegmentVersionMapper.INSTANCE.entityToResponse((SegmentVersion)version));
    }

    public SegmentResponse delete(String projectKey, String segmentKey) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        if (this.targetingSegmentRepository.countByProjectKeyAndSegmentKey(projectKey, segmentKey) > 0) {
            throw new IllegalArgumentException("resource.error.using");
        }
        Segment segment = (Segment)this.segmentRepository.findByProjectKeyAndKey(projectKey, segmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.SEGMENT, projectKey + "_" + segmentKey));
        segment.setDeleted(true);
        if (CollectionUtils.isNotEmpty((Collection)project.getEnvironments())) {
            for (Environment environment : project.getEnvironments()) {
                this.changeLogService.create(environment, ChangeLogType.CHANGE);
            }
        }
        return SegmentMapper.INSTANCE.entityToResponse((Segment)this.segmentRepository.save((Object)segment));
    }

    @Archived
    public Page<ToggleSegmentResponse> usingToggles(String projectKey, String segmentKey, PaginationRequest paginationRequest) {
        List targetingSegments = this.targetingSegmentRepository.findByProjectKeyAndSegmentKey(projectKey, segmentKey);
        List targetingList = this.targetingRepository.findAllById((Iterable)targetingSegments.stream().map(TargetingSegment::getTargetingId).collect(Collectors.toList()));
        List toggles = this.toggleRepository.findAllByProjectKeyAndKeyIn(projectKey, (Iterable)targetingList.stream().map(Targeting::getToggleKey).collect(Collectors.toList()));
        Map toggleMap = toggles.stream().collect(Collectors.toMap(Toggle::getKey, Function.identity()));
        Map<Long, String> targetingIdToToggleKey = targetingList.stream().collect(Collectors.toMap(AbstractAuditEntity::getId, Targeting::getToggleKey));
        List targetingIds = targetingSegments.stream().filter(targetingSegment -> toggleMap.get(targetingIdToToggleKey.get(targetingSegment.getTargetingId())) != null).map(TargetingSegment::getTargetingId).collect(Collectors.toList());
        PageRequest pageable = PageRequest.of((int)paginationRequest.getPageIndex(), (int)paginationRequest.getPageSize(), (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdTime"});
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p0 = root.get("id").in((Collection)targetingIds);
            query.where((Expression)cb.and(new Predicate[]{p0}));
            return query.getRestriction();
        };
        Page targetingPage = this.targetingRepository.findAll((Specification)spec, (Pageable)pageable);
        Page res = targetingPage.map(targeting -> {
            Toggle toggle = (Toggle)toggleMap.get(targeting.getToggleKey());
            ToggleSegmentResponse toggleSegmentResponse = SegmentMapper.INSTANCE.toggleToToggleSegment(toggle);
            toggleSegmentResponse.setDisabled(targeting.isDisabled());
            Optional environment = this.environmentRepository.findByProjectKeyAndKey(projectKey, targeting.getEnvironmentKey());
            Optional toggleControlConfOptional = this.toggleControlConfRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(targeting.getProjectKey(), targeting.getEnvironmentKey(), targeting.getToggleKey());
            toggleSegmentResponse.setAnalyzing(toggleControlConfOptional.isPresent() && ((ToggleControlConf)toggleControlConfOptional.get()).isTrackAccessEvents());
            toggleSegmentResponse.setEnvironmentName(((Environment)environment.get()).getName());
            toggleSegmentResponse.setEnvironmentKey(((Environment)environment.get()).getKey());
            return toggleSegmentResponse;
        });
        return res;
    }

    public SegmentResponse queryByKey(String projectKey, String segmentKey) {
        Segment segment = (Segment)this.segmentRepository.findByProjectKeyAndKey(projectKey, segmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.SEGMENT, projectKey + "_" + segmentKey));
        return SegmentMapper.INSTANCE.entityToResponse(segment);
    }

    private SegmentVersion buildSegmentVersion(Segment segment, String comment, Long approvalId) {
        SegmentVersion segmentVersion = new SegmentVersion();
        segmentVersion.setVersion(segment.getVersion());
        segmentVersion.setKey(segment.getKey());
        segmentVersion.setRules(segment.getRules());
        segmentVersion.setComment(comment);
        segmentVersion.setApprovalId(approvalId);
        segmentVersion.setProjectKey(segment.getProjectKey());
        return segmentVersion;
    }

    private void saveSegmentVersion(SegmentVersion segmentVersion) {
        this.segmentVersionRepository.save((Object)segmentVersion);
    }

    private Specification<Segment> buildQuerySpec(String projectKey, String keyword) {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate p3 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                Predicate p0 = cb.like((Expression)root.get("name"), "%" + keyword + "%");
                Predicate p1 = cb.like((Expression)root.get("key"), "%" + keyword + "%");
                Predicate p2 = cb.like((Expression)root.get("description"), "%" + keyword + "%");
                query.where(new Predicate[]{cb.or(new Predicate[]{p0, p1, p2}), cb.and(new Predicate[]{p3})});
            } else {
                query.where((Expression)p3);
            }
            return query.getRestriction();
        };
    }

    private Page<SegmentResponse> findPagingBySpec(Specification<Segment> spec, Pageable pageable) {
        Page segments = this.segmentRepository.findAll(spec, pageable);
        return segments.map(segment -> SegmentMapper.INSTANCE.entityToResponse((Segment)segment));
    }

    private Specification<SegmentVersion> buildVersionsQuerySpec(String projectKey, String key) {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = cb.equal((Expression)root.get("key"), (Object)key);
            return query.where((Expression)cb.and((Expression)p1, (Expression)p2)).getRestriction();
        };
    }

    public void validateExists(String projectKey, ValidateTypeEnum type, String value) {
        switch (type) {
            case KEY: {
                this.validateKey(projectKey, value);
                break;
            }
            case NAME: {
                this.validateName(projectKey, value);
                break;
            }
        }
    }

    public void validateKey(String projectKey, String key) {
        if (this.segmentRepository.existsByProjectKeyAndKey(projectKey, key)) {
            throw new ResourceConflictException(ResourceType.SEGMENT);
        }
    }

    public void validateName(String projectKey, String name) {
        if (this.segmentRepository.existsByProjectKeyAndName(projectKey, name)) {
            throw new ResourceConflictException(ResourceType.SEGMENT);
        }
    }

    @Generated
    public SegmentService(SegmentRepository segmentRepository, TargetingSegmentRepository targetingSegmentRepository, TargetingRepository targetingRepository, ToggleRepository toggleRepository, EnvironmentRepository environmentRepository, ProjectRepository projectRepository, SegmentVersionRepository segmentVersionRepository, ToggleControlConfRepository toggleControlConfRepository, ChangeLogService changeLogService, EntityManager entityManager) {
        this.segmentRepository = segmentRepository;
        this.targetingSegmentRepository = targetingSegmentRepository;
        this.targetingRepository = targetingRepository;
        this.toggleRepository = toggleRepository;
        this.environmentRepository = environmentRepository;
        this.projectRepository = projectRepository;
        this.segmentVersionRepository = segmentVersionRepository;
        this.toggleControlConfRepository = toggleControlConfRepository;
        this.changeLogService = changeLogService;
        this.entityManager = entityManager;
    }
}

