/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.enums.ApprovalStatusEnum;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.SketchStatusEnum;
import io.featureprobe.api.base.enums.ToggleReleaseStatusEnum;
import io.featureprobe.api.base.model.BaseRule;
import io.featureprobe.api.base.model.ConditionValue;
import io.featureprobe.api.base.model.PaginationRequest;
import io.featureprobe.api.base.model.PrerequisiteModel;
import io.featureprobe.api.base.model.SegmentRuleModel;
import io.featureprobe.api.base.model.TargetingContent;
import io.featureprobe.api.base.model.ToggleRule;
import io.featureprobe.api.base.model.Variation;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.base.util.ToggleContentLimitChecker;
import io.featureprobe.api.config.AppConfig;
import io.featureprobe.api.dao.entity.ApprovalRecord;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Prerequisite;
import io.featureprobe.api.dao.entity.Segment;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.TargetingSegment;
import io.featureprobe.api.dao.entity.TargetingSketch;
import io.featureprobe.api.dao.entity.TargetingVersion;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dao.entity.ToggleControlConf;
import io.featureprobe.api.dao.entity.VariationHistory;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.ApprovalRecordRepository;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.PrerequisiteRepository;
import io.featureprobe.api.dao.repository.SegmentRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dao.repository.TargetingSegmentRepository;
import io.featureprobe.api.dao.repository.TargetingSketchRepository;
import io.featureprobe.api.dao.repository.TargetingVersionRepository;
import io.featureprobe.api.dao.repository.ToggleRepository;
import io.featureprobe.api.dao.repository.VariationHistoryRepository;
import io.featureprobe.api.dao.utils.PageRequestUtil;
import io.featureprobe.api.dto.AfterTargetingVersionResponse;
import io.featureprobe.api.dto.ApprovalResponse;
import io.featureprobe.api.dto.CancelSketchRequest;
import io.featureprobe.api.dto.DependentToggleRequest;
import io.featureprobe.api.dto.DependentToggleResponse;
import io.featureprobe.api.dto.PrerequisiteToggleRequest;
import io.featureprobe.api.dto.PrerequisiteToggleResponse;
import io.featureprobe.api.dto.TargetingApprovalRequest;
import io.featureprobe.api.dto.TargetingDiffResponse;
import io.featureprobe.api.dto.TargetingPublishRequest;
import io.featureprobe.api.dto.TargetingResponse;
import io.featureprobe.api.dto.TargetingVersionRequest;
import io.featureprobe.api.dto.TargetingVersionResponse;
import io.featureprobe.api.dto.ToggleControlConfRequest;
import io.featureprobe.api.dto.UpdateApprovalStatusRequest;
import io.featureprobe.api.mapper.ApprovalRecordMapper;
import io.featureprobe.api.mapper.TargetingMapper;
import io.featureprobe.api.mapper.TargetingVersionMapper;
import io.featureprobe.api.service.ChangeLogService;
import io.featureprobe.api.service.MetricService;
import io.featureprobe.api.service.ToggleControlConfService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TargetingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TargetingService.class);
    private static final Pattern dateTimeRegex = Pattern.compile("[0-9]{3}[0-9]-[0-1][0-9]-[0-3][0-9]T[0-2][0-9](:[0-6][0-9]){2}\\+[0-2][0-9]:[0-1][0-9]");
    private static final Pattern versionRegex = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private TargetingRepository targetingRepository;
    private SegmentRepository segmentRepository;
    private TargetingSegmentRepository targetingSegmentRepository;
    private TargetingVersionRepository targetingVersionRepository;
    private VariationHistoryRepository variationHistoryRepository;
    private EnvironmentRepository environmentRepository;
    private ApprovalRecordRepository approvalRecordRepository;
    private TargetingSketchRepository targetingSketchRepository;
    private ToggleRepository toggleRepository;
    private PrerequisiteRepository prerequisiteRepository;
    private ChangeLogService changeLogService;
    private ToggleControlConfService toggleControlConfService;
    private MetricService metricService;
    private AppConfig appConfig;
    @PersistenceContext
    public EntityManager entityManager;

    @Transactional(rollbackFor={Exception.class})
    public TargetingResponse publish(String projectKey, String environmentKey, String toggleKey, TargetingPublishRequest targetingPublishRequest) {
        List prerequisites;
        if (Objects.nonNull(targetingPublishRequest.getContent()) && !org.springframework.util.CollectionUtils.isEmpty((Collection)(prerequisites = targetingPublishRequest.getContent().getPrerequisites()))) {
            if (this.hasDependencyCycle(projectKey, environmentKey, toggleKey, new HashSet<PrerequisiteModel>(prerequisites), this.appConfig.getMaximumDependencyDepth())) {
                throw new IllegalArgumentException("validate.prerequisite.dependency.cycle");
            }
            this.updateDependentToggles(projectKey, environmentKey, toggleKey, prerequisites);
        }
        Environment environment = this.selectEnvironment(projectKey, environmentKey);
        TargetingResponse response = this.publishTargeting(projectKey, environmentKey, toggleKey, targetingPublishRequest, null);
        this.changeLogService.create(environment, ChangeLogType.CHANGE);
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApprovalResponse approval(String projectKey, String environmentKey, String toggleKey, TargetingApprovalRequest approvalRequest) {
        this.validateTargetingContent(projectKey, approvalRequest.getContent());
        List prerequisites = approvalRequest.getContent().getPrerequisites();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)prerequisites) && this.hasDependencyCycle(projectKey, environmentKey, toggleKey, new HashSet<PrerequisiteModel>(prerequisites), this.appConfig.getMaximumDependencyDepth())) {
            throw new IllegalArgumentException("validate.prerequisite.dependency.cycle");
        }
        Environment environment = this.selectEnvironment(projectKey, environmentKey);
        if (environment.isEnableApproval()) {
            List reviews = JsonMapper.toListObject((String)environment.getReviewers(), String.class);
            approvalRequest.setReviewers(reviews);
            Targeting targeting = this.selectTargeting(projectKey, environmentKey, toggleKey);
            if (targeting.getStatus() == ToggleReleaseStatusEnum.PENDING_APPROVAL) {
                throw new IllegalArgumentException("validate.approval.repeat");
            }
            targeting.setStatus(ToggleReleaseStatusEnum.PENDING_APPROVAL);
            this.targetingRepository.save((Object)targeting);
            ApprovalRecord approvalRecord = this.submitApproval(projectKey, environmentKey, toggleKey, approvalRequest);
            Targeting approval = new Targeting();
            approval.setDisabled(approvalRequest.getDisabled().booleanValue());
            approval.setContent(JsonMapper.toJSONString((Object)approvalRequest.getContent()));
            return this.buildApprovalResponse(approvalRecord, targeting, approval);
        }
        throw new IllegalArgumentException("validate.approval.disable");
    }

    private void updateDependentToggles(String projectKey, String environmentKey, String toggleKey, List<PrerequisiteModel> prerequisiteModels) {
        this.prerequisiteRepository.deleteAllByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey);
        List prerequisites = prerequisiteModels.stream().map(prerequisiteModel -> this.buildPrerequisite(projectKey, environmentKey, toggleKey, (PrerequisiteModel)prerequisiteModel)).collect(Collectors.toList());
        this.prerequisiteRepository.saveAll(prerequisites);
    }

    private Prerequisite buildPrerequisite(String projectKey, String environmentKey, String toggleKey, PrerequisiteModel prerequisiteModel) {
        Prerequisite prerequisite = new Prerequisite();
        prerequisite.setProjectKey(projectKey);
        prerequisite.setEnvironmentKey(environmentKey);
        prerequisite.setToggleKey(toggleKey);
        prerequisite.setParentToggleKey(prerequisiteModel.getKey());
        prerequisite.setDependentValue(prerequisiteModel.getValue());
        return prerequisite;
    }

    private ApprovalResponse buildApprovalResponse(ApprovalRecord approvalRecord, Targeting currentData, Targeting approvalData) {
        ApprovalResponse approvalResponse = ApprovalRecordMapper.INSTANCE.entityToApprovalResponse(approvalRecord);
        HashMap<String, Object> current = new HashMap<String, Object>();
        current.put("disabled", currentData.isDisabled());
        current.put("content", currentData.getContent());
        approvalResponse.setCurrentData(current);
        HashMap<String, Object> approval = new HashMap<String, Object>();
        approval.put("disabled", approvalData.isDisabled());
        approval.put("content", approvalData.getContent());
        approvalResponse.setApprovalData(approval);
        return approvalResponse;
    }

    private boolean hasDependencyCycle(String projectKey, String environmentKey, String rootToggleKey, Set<PrerequisiteModel> parentPrerequisites, int deep) {
        if (deep == 0) {
            throw new IllegalArgumentException("validate.prerequisite.deep.limit");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(parentPrerequisites)) {
            return false;
        }
        Set parentToggleKeys = parentPrerequisites.stream().map(PrerequisiteModel::getKey).collect(Collectors.toSet());
        if (parentToggleKeys.contains(rootToggleKey)) {
            return true;
        }
        List targetingList = this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKeyIn(projectKey, environmentKey, parentToggleKeys);
        Set<PrerequisiteModel> prerequisite = targetingList.stream().map(Targeting::getContent).map(content -> ((TargetingContent)JsonMapper.toObject((String)content, TargetingContent.class)).getPrerequisites()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.hasDependencyCycle(projectKey, environmentKey, rootToggleKey, prerequisite, deep - 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public TargetingResponse publishSketch(String projectKey, String environmentKey, String toggleKey, ToggleControlConfRequest controlConfRequest) {
        Optional<ApprovalRecord> approvalRecordOptional = this.queryNewestApprovalRecord(projectKey, environmentKey, toggleKey);
        Optional<TargetingSketch> targetingSketchOptional = this.queryNewestTargetingSketch(projectKey, environmentKey, toggleKey);
        Environment environment = this.selectEnvironment(projectKey, environmentKey);
        if (approvalRecordOptional.isPresent() && targetingSketchOptional.isPresent() && this.publishableStatus(approvalRecordOptional.get())) {
            TargetingSketch sketch = targetingSketchOptional.get();
            sketch.setStatus(SketchStatusEnum.RELEASE);
            this.targetingSketchRepository.save((Object)sketch);
            TargetingPublishRequest targetingPublishRequest = new TargetingPublishRequest((TargetingContent)JsonMapper.toObject((String)sketch.getContent(), TargetingContent.class), sketch.getComment(), sketch.getDisabled(), controlConfRequest);
            this.changeLogService.create(environment, ChangeLogType.CHANGE);
            return this.publishTargeting(projectKey, environmentKey, toggleKey, targetingPublishRequest, approvalRecordOptional.get().getId());
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TargetingResponse cancelSketch(String projectKey, String environmentKey, String toggleKey, CancelSketchRequest cancelSketchRequest) {
        Optional<ApprovalRecord> approvalRecordOptional = this.queryNewestApprovalRecord(projectKey, environmentKey, toggleKey);
        Optional<TargetingSketch> targetingSketchOptional = this.queryNewestTargetingSketch(projectKey, environmentKey, toggleKey);
        Targeting targeting = this.selectTargeting(projectKey, environmentKey, toggleKey);
        if (approvalRecordOptional.isPresent() && targetingSketchOptional.isPresent()) {
            TargetingSketch sketch = targetingSketchOptional.get();
            sketch.setStatus(SketchStatusEnum.CANCEL);
            sketch.setComment(cancelSketchRequest.getComment());
            targeting.setStatus(ToggleReleaseStatusEnum.RELEASE);
            this.targetingSketchRepository.save((Object)sketch);
            Targeting save = (Targeting)this.targetingRepository.save((Object)targeting);
            return TargetingMapper.INSTANCE.entityToResponse(save);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApprovalResponse updateApprovalStatus(String projectKey, String environmentKey, String toggleKey, UpdateApprovalStatusRequest updateRequest) {
        Optional<ApprovalRecord> approvalRecordOptional = this.queryNewestApprovalRecord(projectKey, environmentKey, toggleKey);
        Optional<TargetingSketch> targetingSketchOptional = this.queryNewestTargetingSketch(projectKey, environmentKey, toggleKey);
        Targeting targeting = this.selectTargeting(projectKey, environmentKey, toggleKey);
        if (approvalRecordOptional.isPresent() && targetingSketchOptional.isPresent() && this.checkStateMachine(approvalRecordOptional.get(), updateRequest.getStatus())) {
            if (updateRequest.getStatus() == ApprovalStatusEnum.REVOKE) {
                TargetingSketch sketch = targetingSketchOptional.get();
                sketch.setStatus(SketchStatusEnum.REVOKE);
                this.targetingSketchRepository.save((Object)sketch);
            }
            ApprovalRecord approvalRecord = approvalRecordOptional.get();
            approvalRecord.setStatus(updateRequest.getStatus());
            approvalRecord.setComment(updateRequest.getComment());
            approvalRecord.setApprovedBy(TokenHelper.getAccount());
            this.approvalRecordRepository.saveAndFlush((Object)approvalRecord);
            if (updateRequest.getStatus() == ApprovalStatusEnum.JUMP) {
                this.publishSketch(projectKey, environmentKey, toggleKey, updateRequest);
            }
            if (updateRequest.getStatus() == ApprovalStatusEnum.PASS) {
                targeting.setStatus(ToggleReleaseStatusEnum.PENDING_RELEASE);
            } else if (updateRequest.getStatus() == ApprovalStatusEnum.REJECT) {
                targeting.setStatus(ToggleReleaseStatusEnum.REJECT);
            } else {
                targeting.setStatus(ToggleReleaseStatusEnum.RELEASE);
            }
            Targeting current = (Targeting)this.targetingRepository.save((Object)targeting);
            Targeting approval = new Targeting();
            approval.setDisabled(targetingSketchOptional.get().getDisabled().booleanValue());
            approval.setContent(targetingSketchOptional.get().getContent());
            return this.buildApprovalResponse(approvalRecord, current, approval);
        }
        throw new IllegalArgumentException();
    }

    private boolean checkStateMachine(ApprovalRecord approvalRecord, ApprovalStatusEnum status) {
        switch (status) {
            case PASS: 
            case REJECT: {
                return approvalRecord.getStatus() == ApprovalStatusEnum.PENDING && JsonMapper.toListObject((String)approvalRecord.getReviewers(), String.class).contains(TokenHelper.getAccount());
            }
            case REVOKE: 
            case JUMP: {
                return approvalRecord.getStatus() == ApprovalStatusEnum.PENDING && TenantContext.getCurrentOrganization().getRole() == OrganizationRoleEnum.OWNER;
            }
        }
        return false;
    }

    public Page<TargetingVersionResponse> queryVersions(String projectKey, String environmentKey, String toggleKey, TargetingVersionRequest targetingVersionRequest) {
        Page targetingVersions = Objects.isNull(targetingVersionRequest.getVersion()) ? this.targetingVersionRepository.findAllByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey, PageRequestUtil.toCreatedTimeDescSortPageable((PaginationRequest)targetingVersionRequest)) : this.targetingVersionRepository.findAllByProjectKeyAndEnvironmentKeyAndToggleKeyAndVersionLessThanOrderByVersionDesc(projectKey, environmentKey, toggleKey, targetingVersionRequest.getVersion(), PageRequestUtil.toCreatedTimeDescSortPageable((PaginationRequest)targetingVersionRequest));
        return targetingVersions.map(targetingVersion -> this.translateTargetingVersionResponse((TargetingVersion)targetingVersion));
    }

    public AfterTargetingVersionResponse queryAfterVersion(String projectKey, String environmentKey, String toggleKey, Long version) {
        List targetingVersions = this.targetingVersionRepository.findAllByProjectKeyAndEnvironmentKeyAndToggleKeyAndVersionGreaterThanEqualOrderByVersionDesc(projectKey, environmentKey, toggleKey, version);
        List<TargetingVersionResponse> versions = targetingVersions.stream().map(targetingVersion -> this.translateTargetingVersionResponse((TargetingVersion)targetingVersion)).collect(Collectors.toList());
        long total = this.targetingVersionRepository.countByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey);
        return new AfterTargetingVersionResponse(total, versions);
    }

    private TargetingVersionResponse translateTargetingVersionResponse(TargetingVersion targetingVersion) {
        TargetingVersionResponse targetingVersionResponse = TargetingVersionMapper.INSTANCE.entityToResponse(targetingVersion);
        if (Objects.nonNull(targetingVersion.getApprovalId())) {
            Optional approvalRecord = this.approvalRecordRepository.findById((Object)targetingVersion.getApprovalId());
            targetingVersionResponse.setApprovalStatus(((ApprovalRecord)approvalRecord.get()).getStatus());
            targetingVersionResponse.setApprovalTime(((ApprovalRecord)approvalRecord.get()).getModifiedTime());
            targetingVersionResponse.setApprovalBy(((ApprovalRecord)approvalRecord.get()).getApprovedBy());
            targetingVersionResponse.setApprovalComment(((ApprovalRecord)approvalRecord.get()).getComment());
        }
        return targetingVersionResponse;
    }

    public TargetingDiffResponse diff(String projectKey, String environmentKey, String toggleKey) {
        TargetingDiffResponse diffResponse = new TargetingDiffResponse();
        Optional<TargetingSketch> targetingSketch = this.queryNewestTargetingSketch(projectKey, environmentKey, toggleKey);
        Optional targeting = this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey);
        if (targetingSketch.isPresent() && targeting.isPresent()) {
            diffResponse.setCurrentDisabled(targetingSketch.get().getDisabled());
            diffResponse.setCurrentContent((TargetingContent)JsonMapper.toObject((String)targetingSketch.get().getContent(), TargetingContent.class));
            diffResponse.setOldDisabled(((Targeting)targeting.get()).isDisabled());
            diffResponse.setOldContent((TargetingContent)JsonMapper.toObject((String)((Targeting)targeting.get()).getContent(), TargetingContent.class));
        }
        return diffResponse;
    }

    public TargetingResponse queryByKey(String projectKey, String environmentKey, String toggleKey) {
        Environment environment = this.selectEnvironment(projectKey, environmentKey);
        Targeting targeting = (Targeting)this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey).get();
        TargetingResponse targetingResponse = TargetingMapper.INSTANCE.entityToResponse(targeting);
        Optional<ApprovalRecord> newestApprovalRecord = this.queryNewestApprovalRecord(projectKey, environmentKey, toggleKey);
        Optional<TargetingSketch> targetingSketch = this.queryNewestTargetingSketch(projectKey, environmentKey, toggleKey);
        if (newestApprovalRecord.isPresent() && targetingSketch.isPresent() && this.locked(targetingSketch.get())) {
            targetingResponse.setContent((TargetingContent)JsonMapper.toObject((String)targetingSketch.get().getContent(), TargetingContent.class));
            targetingResponse.setDisabled(targetingSketch.get().getDisabled());
            targetingResponse.setVersion(targetingSketch.get().getOldVersion() + 1L);
            targetingResponse.setStatus(newestApprovalRecord.get().getStatus().name());
            targetingResponse.setReviewers(JsonMapper.toListObject((String)newestApprovalRecord.get().getReviewers(), String.class));
            targetingResponse.setSubmitBy(newestApprovalRecord.get().getSubmitBy());
            targetingResponse.setApprovalBy(newestApprovalRecord.get().getApprovedBy());
            targetingResponse.setApprovalComment(newestApprovalRecord.get().getComment());
            targetingResponse.setLocked(true);
            targetingResponse.setLockedTime(newestApprovalRecord.get().getCreatedTime());
        } else {
            targetingResponse.setStatus(SketchStatusEnum.RELEASE.name());
            if (environment.isEnableApproval()) {
                targetingResponse.setReviewers(JsonMapper.toListObject((String)environment.getReviewers(), String.class));
            }
        }
        targetingResponse.setEnableApproval(environment.isEnableApproval());
        targetingResponse.setPublishTime(targeting.getPublishTime());
        Boolean trackAccessEvents = this.toggleControlConfService.queryToggleControlConf(targeting).isTrackAccessEvents();
        targetingResponse.setTrackAccessEvents(trackAccessEvents);
        targetingResponse.setAllowEnableTrackAccessEvents(BooleanUtils.isFalse((Boolean)trackAccessEvents) && this.metricService.existsMetric(targeting.getProjectKey(), targeting.getEnvironmentKey(), targeting.getToggleKey()));
        if (Objects.isNull(targetingResponse.getContent().getPrerequisites())) {
            targetingResponse.getContent().setPrerequisites(Collections.emptyList());
        }
        return targetingResponse;
    }

    private boolean locked(TargetingSketch targetingSketch) {
        return targetingSketch.getStatus() == SketchStatusEnum.PENDING;
    }

    private boolean publishableStatus(ApprovalRecord approvalRecord) {
        return approvalRecord.getStatus() == ApprovalStatusEnum.JUMP || approvalRecord.getStatus() == ApprovalStatusEnum.PASS;
    }

    private ApprovalRecord submitApproval(String projectKey, String environmentKey, String toggleKey, TargetingApprovalRequest approvalRequest) {
        Targeting targeting = this.selectTargeting(projectKey, environmentKey, toggleKey);
        ApprovalRecord approvalRecord = (ApprovalRecord)this.approvalRecordRepository.save((Object)this.buildApprovalRecord(projectKey, environmentKey, toggleKey, approvalRequest));
        this.targetingSketchRepository.save((Object)this.buildTargetingSketch(projectKey, environmentKey, toggleKey, approvalRecord.getId(), targeting.getVersion(), approvalRequest));
        return approvalRecord;
    }

    private TargetingResponse publishTargeting(String projectKey, String environmentKey, String toggleKey, TargetingPublishRequest targetingPublishRequest, Long approvalId) {
        Targeting latestTargeting = this.selectTargeting(projectKey, environmentKey, toggleKey);
        if (targetingPublishRequest.isUpdateTargetingRules().booleanValue()) {
            latestTargeting = this.updateTargeting(projectKey, latestTargeting, targetingPublishRequest);
            this.saveTargetingSegmentRefs(projectKey, latestTargeting, targetingPublishRequest.getContent());
            this.saveTargetingVersion(this.buildTargetingVersion(latestTargeting, targetingPublishRequest.getComment(), approvalId));
            this.saveVariationHistory(latestTargeting, targetingPublishRequest.getContent());
            latestTargeting.setStatus(ToggleReleaseStatusEnum.RELEASE);
        }
        ToggleControlConf toggleControlConf = this.toggleControlConfService.updateTrackAccessEvents(latestTargeting, targetingPublishRequest.getTrackAccessEvents());
        TargetingResponse targetingResponse = TargetingMapper.INSTANCE.entityToResponse(latestTargeting);
        targetingResponse.setTrackAccessEvents(toggleControlConf.isTrackAccessEvents());
        return targetingResponse;
    }

    private ApprovalRecord buildApprovalRecord(String projectKey, String environmentKey, String toggleKey, TargetingApprovalRequest approvalRequest) {
        ApprovalRecord approvalRecord = new ApprovalRecord();
        approvalRecord.setProjectKey(projectKey);
        approvalRecord.setEnvironmentKey(environmentKey);
        approvalRecord.setToggleKey(toggleKey);
        approvalRecord.setTitle(approvalRequest.getComment());
        approvalRecord.setSubmitBy(TokenHelper.getAccount());
        approvalRecord.setReviewers(JsonMapper.toJSONString(approvalRequest.getReviewers()));
        approvalRecord.setStatus(ApprovalStatusEnum.PENDING);
        return approvalRecord;
    }

    private TargetingSketch buildTargetingSketch(String projectKey, String environmentKey, String toggleKey, Long approvalId, Long oldVersion, TargetingApprovalRequest approvalRequest) {
        TargetingSketch sketch = new TargetingSketch();
        sketch.setApprovalId(approvalId);
        sketch.setProjectKey(projectKey);
        sketch.setEnvironmentKey(environmentKey);
        sketch.setToggleKey(toggleKey);
        sketch.setOldVersion(oldVersion);
        sketch.setContent(JsonMapper.toJSONString((Object)approvalRequest.getContent()));
        sketch.setComment(approvalRequest.getComment());
        sketch.setDisabled(approvalRequest.getDisabled());
        sketch.setStatus(SketchStatusEnum.PENDING);
        return sketch;
    }

    private Targeting updateTargeting(String projectKey, Targeting currentTargeting, TargetingPublishRequest updateTargetingPublishRequest) {
        TargetingContent currentTargetingContent = (TargetingContent)JsonMapper.toObject((String)currentTargeting.getContent(), TargetingContent.class);
        TargetingMapper.INSTANCE.mapContentEntity(updateTargetingPublishRequest.getContent(), currentTargetingContent);
        this.validatePublishConflicts(currentTargeting, updateTargetingPublishRequest.getBaseVersion());
        this.validateTargetingContent(projectKey, currentTargetingContent);
        updateTargetingPublishRequest.setContent(currentTargetingContent);
        TargetingMapper.INSTANCE.mapEntity(updateTargetingPublishRequest, currentTargeting);
        currentTargeting.setVersion(Long.valueOf(currentTargeting.getVersion() + 1L));
        currentTargeting.setPublishTime(new Date());
        return (Targeting)this.targetingRepository.saveAndFlush((Object)currentTargeting);
    }

    private TargetingVersion buildTargetingVersion(Targeting targeting, String comment, Long approvalId) {
        TargetingVersion targetingVersion = new TargetingVersion();
        targetingVersion.setProjectKey(targeting.getProjectKey());
        targetingVersion.setEnvironmentKey(targeting.getEnvironmentKey());
        targetingVersion.setToggleKey(targeting.getToggleKey());
        targetingVersion.setContent(targeting.getContent());
        targetingVersion.setDisabled(Boolean.valueOf(targeting.isDisabled()));
        targetingVersion.setVersion(targeting.getVersion());
        targetingVersion.setComment(comment);
        targetingVersion.setApprovalId(approvalId);
        return targetingVersion;
    }

    @Transactional(rollbackFor={Exception.class})
    public void createDefaultTargetingEntities(String projectKey, Toggle toggle) {
        List environments = this.environmentRepository.findAllByProjectKey(projectKey);
        if (CollectionUtils.isEmpty((Collection)environments)) {
            log.info("{} environment is empty, ignore create targeting", (Object)projectKey);
            return;
        }
        List<Targeting> targetingList = environments.stream().map(environment -> this.createDefaultTargeting(toggle, (Environment)environment)).collect(Collectors.toList());
        environments.stream().forEach(environment -> this.changeLogService.create((Environment)environment, ChangeLogType.CHANGE));
        this.createTargetingEntities(targetingList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createTargetingEntities(List<Targeting> targetingList) {
        List savedTargetingList = this.targetingRepository.saveAll(targetingList);
        for (Targeting targeting : savedTargetingList) {
            this.saveTargetingVersion(this.buildTargetingVersion(targeting, ""));
            this.saveVariationHistory(targeting);
        }
    }

    private void saveTargetingVersion(TargetingVersion targetingVersion) {
        this.targetingVersionRepository.save((Object)targetingVersion);
    }

    private void saveVariationHistory(Targeting targeting) {
        List variations = ((TargetingContent)JsonMapper.toObject((String)targeting.getContent(), TargetingContent.class)).getVariations();
        List variationHistories = IntStream.range(0, variations.size()).mapToObj(index -> this.convertVariationToEntity(targeting, index, (Variation)variations.get(index))).collect(Collectors.toList());
        this.variationHistoryRepository.saveAll(variationHistories);
    }

    private VariationHistory convertVariationToEntity(Targeting targeting, int index, Variation variation) {
        VariationHistory variationHistory = new VariationHistory();
        variationHistory.setEnvironmentKey(targeting.getEnvironmentKey());
        variationHistory.setProjectKey(targeting.getProjectKey());
        variationHistory.setToggleKey(targeting.getToggleKey());
        variationHistory.setValue(variation.getValue());
        variationHistory.setName(variation.getName());
        variationHistory.setToggleVersion(targeting.getVersion());
        variationHistory.setValueIndex(Integer.valueOf(index));
        return variationHistory;
    }

    private TargetingVersion buildTargetingVersion(Targeting targeting, String comment) {
        TargetingVersion targetingVersion = new TargetingVersion();
        targetingVersion.setProjectKey(targeting.getProjectKey());
        targetingVersion.setEnvironmentKey(targeting.getEnvironmentKey());
        targetingVersion.setToggleKey(targeting.getToggleKey());
        targetingVersion.setContent(targeting.getContent());
        targetingVersion.setDisabled(Boolean.valueOf(targeting.isDisabled()));
        targetingVersion.setVersion(targeting.getVersion());
        targetingVersion.setComment(comment);
        return targetingVersion;
    }

    private Targeting createDefaultTargeting(Toggle toggle, Environment environment) {
        Targeting targeting = new Targeting();
        targeting.setDeleted(false);
        targeting.setVersion(Long.valueOf(1L));
        targeting.setProjectKey(toggle.getProjectKey());
        targeting.setDisabled(true);
        targeting.setContent(TargetingContent.newDefault((String)toggle.getVariations(), (Integer)toggle.getDisabledServe()).toJson());
        targeting.setToggleKey(toggle.getKey());
        targeting.setEnvironmentKey(environment.getKey());
        targeting.setPublishTime(new Date());
        return targeting;
    }

    private void saveTargetingSegmentRefs(String projectKey, Targeting targeting, TargetingContent targetingContent) {
        this.targetingSegmentRepository.deleteByTargetingId(targeting.getId());
        List<TargetingSegment> targetingSegmentList = this.getTargetingSegments(projectKey, targeting, targetingContent);
        if (!org.springframework.util.CollectionUtils.isEmpty(targetingSegmentList)) {
            this.targetingSegmentRepository.saveAll(targetingSegmentList);
        }
    }

    private List<TargetingSegment> getTargetingSegments(String projectKey, Targeting targeting, TargetingContent targetingContent) {
        TreeSet segmentKeys = new TreeSet();
        targetingContent.getRules().forEach(toggleRule -> toggleRule.getConditions().stream().filter(ConditionValue::isSegmentType).forEach(conditionValue -> segmentKeys.addAll(conditionValue.getObjects())));
        return segmentKeys.stream().map(segmentKey -> new TargetingSegment(targeting.getId(), segmentKey, projectKey)).collect(Collectors.toList());
    }

    private void saveVariationHistory(Targeting targeting, TargetingContent targetingContent) {
        List variations = targetingContent.getVariations();
        List variationHistories = IntStream.range(0, targetingContent.getVariations().size()).mapToObj(index -> this.convertVariationToEntity(targeting, index, (Variation)variations.get(index))).collect(Collectors.toList());
        this.variationHistoryRepository.saveAll(variationHistories);
    }

    private Optional<ApprovalRecord> queryNewestApprovalRecord(String projectKey, String environmentKey, String toggleKey) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = cb.equal((Expression)root.get("environmentKey"), (Object)environmentKey);
            Predicate p3 = cb.equal((Expression)root.get("toggleKey"), (Object)toggleKey);
            return query.where(new Predicate[]{p1, p2, p3}).getRestriction();
        };
        Pageable pageable = PageRequestUtil.toPageable((PaginationRequest)new PaginationRequest(), (Sort.Direction)Sort.Direction.DESC, (String)"createdTime");
        Page approvalRecords = this.approvalRecordRepository.findAll((Specification)spec, pageable);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)approvalRecords.getContent())) {
            return Optional.empty();
        }
        return Optional.of(approvalRecords.getContent().get(0));
    }

    private Optional<TargetingSketch> queryNewestTargetingSketch(String projectKey, String environmentKey, String toggleKey) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = cb.equal((Expression)root.get("environmentKey"), (Object)environmentKey);
            Predicate p3 = cb.equal((Expression)root.get("toggleKey"), (Object)toggleKey);
            return query.where(new Predicate[]{p1, p2, p3}).getRestriction();
        };
        Pageable pageable = PageRequestUtil.toPageable((PaginationRequest)new PaginationRequest(), (Sort.Direction)Sort.Direction.DESC, (String)"createdTime");
        Page targetingSketches = this.targetingSketchRepository.findAll((Specification)spec, pageable);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)targetingSketches.getContent())) {
            return Optional.empty();
        }
        return Optional.of(targetingSketches.getContent().get(0));
    }

    protected void validatePublishConflicts(Targeting targeting, Long baseVersion) {
        if (baseVersion != null && targeting.getVersion() != null && !targeting.getVersion().equals(baseVersion)) {
            throw new OptimisticLockException("publish conflict");
        }
    }

    protected void validateTargetingContent(String projectKey, TargetingContent content) {
        if (Objects.isNull(content) && org.springframework.util.CollectionUtils.isEmpty((Collection)content.getRules())) {
            return;
        }
        ToggleContentLimitChecker.validateSize((String)content.toJson());
        content.getRules().stream().filter(BaseRule::isNotEmptyConditions).forEach(toggleRule -> {
            this.validateRuleRefSegmentExists(projectKey, (ToggleRule)toggleRule);
            this.validateNumber((ToggleRule)toggleRule);
            this.validateDatetime((ToggleRule)toggleRule);
            this.validateSemVer((ToggleRule)toggleRule);
        });
    }

    private void validateRuleRefSegmentExists(String projectKey, ToggleRule toggleRule) {
        toggleRule.getConditions().stream().filter(ConditionValue::isSegmentType).forEach(conditionValue -> conditionValue.getObjects().stream().forEach(segmentKey -> {
            if (!this.segmentRepository.existsByProjectKeyAndKey(projectKey, segmentKey)) {
                throw new ResourceNotFoundException(ResourceType.SEGMENT, segmentKey);
            }
        }));
    }

    private void validateNumber(ToggleRule toggleRule) {
        toggleRule.getConditions().stream().filter(ConditionValue::isNumberType).forEach(conditionValue -> conditionValue.getObjects().stream().forEach(number -> {
            try {
                Double.parseDouble(number);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("validate.number_format_error");
            }
        }));
    }

    private void validateDatetime(ToggleRule toggleRule) {
        toggleRule.getConditions().stream().filter(ConditionValue::isDatetimeType).forEach(conditionValue -> conditionValue.getObjects().stream().forEach(datetime -> {
            if (!dateTimeRegex.matcher((CharSequence)datetime).matches()) {
                throw new IllegalArgumentException("validate.datetime_format_error");
            }
        }));
    }

    private void validateSemVer(ToggleRule toggleRule) {
        toggleRule.getConditions().stream().filter(ConditionValue::isSemVerType).forEach(conditionValue -> conditionValue.getObjects().stream().forEach(semVer -> {
            if (!versionRegex.matcher((CharSequence)semVer).matches()) {
                throw new IllegalArgumentException("validate.version_format_error");
            }
        }));
    }

    private Environment selectEnvironment(String projectKey, String environmentKey) {
        return (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, projectKey + "-" + environmentKey));
    }

    private Targeting selectTargeting(String projectKey, String environmentKey, String toggleKey) {
        return (Targeting)this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TARGETING, projectKey + "-" + environmentKey + "-" + toggleKey));
    }

    public List<String> attributes(String projectKey, String environmentKey, String toggleKey) {
        ToggleRule rule;
        List conditions;
        ArrayList<String> res = new ArrayList<String>();
        Targeting targeting = (Targeting)this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TARGETING, projectKey + "-" + environmentKey + "-" + toggleKey));
        TargetingContent targetingContent = (TargetingContent)JsonMapper.toObject((String)targeting.getContent(), TargetingContent.class);
        List rules = targetingContent.getRules();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)rules)) {
            return res;
        }
        Iterator iterator = rules.iterator();
        while (iterator.hasNext() && !org.springframework.util.CollectionUtils.isEmpty((Collection)(conditions = (rule = (ToggleRule)iterator.next()).getConditions()))) {
            for (ConditionValue condition : conditions) {
                if ("segment".equals(condition.getType())) {
                    res.addAll(this.getSegmentAttributes(projectKey, condition.getObjects()));
                    continue;
                }
                res.add(condition.getSubject());
            }
        }
        return res.stream().distinct().collect(Collectors.toList());
    }

    private List<String> getSegmentAttributes(String projectKey, List<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        if (org.springframework.util.CollectionUtils.isEmpty(keys)) {
            return res;
        }
        for (String key : keys) {
            SegmentRuleModel rule;
            List conditions;
            Segment segment = (Segment)this.segmentRepository.findByProjectKeyAndKey(projectKey, key).orElseThrow(() -> new ResourceNotFoundException(ResourceType.SEGMENT, projectKey + "_" + key));
            List segmentRules = JsonMapper.toListObject((String)segment.getRules(), SegmentRuleModel.class);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)segmentRules)) {
                return res;
            }
            Iterator iterator = segmentRules.iterator();
            while (iterator.hasNext() && !org.springframework.util.CollectionUtils.isEmpty((Collection)(conditions = (rule = (SegmentRuleModel)iterator.next()).getConditions()))) {
                for (ConditionValue condition : conditions) {
                    res.add(condition.getSubject());
                }
            }
        }
        return res;
    }

    public List<PrerequisiteToggleResponse> preToggles(String projectKey, String environmentKey, String toggleKey, PrerequisiteToggleRequest query) {
        List<Toggle> nonSelfToggles = this.getNonSelfToggles(projectKey, toggleKey, query);
        List<Targeting> nonSelfTargetingList = this.getNonSelfTargetingList(projectKey, environmentKey, toggleKey);
        Map targetingMap = nonSelfTargetingList.stream().collect(Collectors.toMap(Targeting::getToggleKey, Function.identity()));
        return nonSelfToggles.stream().map(toggle -> this.buildPrerequisiteToggle((Toggle)toggle, targetingMap)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Page<DependentToggleResponse> getDependentToggles(String projectKey, String environmentKey, String toggleKey, DependentToggleRequest requestParam) {
        Page prerequisites = this.prerequisiteRepository.findAllByProjectKeyAndEnvironmentKeyAndParentToggleKey(projectKey, environmentKey, toggleKey, PageRequestUtil.toPageable((PaginationRequest)requestParam, (Sort.Direction)Sort.Direction.DESC, (String)"createdTime"));
        if (prerequisites.isEmpty()) {
            return Page.empty();
        }
        Set dependentToggleKeys = prerequisites.stream().map(Prerequisite::getToggleKey).collect(Collectors.toSet());
        Map toggleMap = this.toggleRepository.findAllByProjectKeyAndKeyIn(projectKey, dependentToggleKeys).stream().collect(Collectors.toMap(Toggle::getKey, Function.identity()));
        Map targetingMap = this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKeyIn(projectKey, environmentKey, dependentToggleKeys).stream().collect(Collectors.toMap(Targeting::getToggleKey, Function.identity()));
        return prerequisites.map(prerequisite -> this.buildDependentToggle((Prerequisite)prerequisite, toggleMap, targetingMap));
    }

    private DependentToggleResponse buildDependentToggle(Prerequisite prerequisite, Map<String, Toggle> toggleMap, Map<String, Targeting> targetingMap) {
        DependentToggleResponse dependentToggle = new DependentToggleResponse();
        dependentToggle.setDependentValue(prerequisite.getDependentValue());
        dependentToggle.setKey(prerequisite.getToggleKey());
        dependentToggle.setName(toggleMap.get(prerequisite.getToggleKey()).getName());
        dependentToggle.setDisabled(targetingMap.get(prerequisite.getToggleKey()).isDisabled());
        return dependentToggle;
    }

    private PrerequisiteToggleResponse buildPrerequisiteToggle(Toggle toggle, Map<String, Targeting> targetingMap) {
        PrerequisiteToggleResponse prerequisiteToggle = new PrerequisiteToggleResponse();
        Targeting targeting = targetingMap.get(toggle.getKey());
        if (Objects.isNull(targeting)) {
            return null;
        }
        prerequisiteToggle.setName(toggle.getName());
        prerequisiteToggle.setKey(toggle.getKey());
        prerequisiteToggle.setReturnType(toggle.getReturnType());
        prerequisiteToggle.setDisabled(targeting.isDisabled());
        List variations = ((TargetingContent)JsonMapper.toObject((String)targeting.getContent(), TargetingContent.class)).getVariations();
        prerequisiteToggle.setVariations(variations);
        return prerequisiteToggle;
    }

    private List<Toggle> getNonSelfToggles(String projectKey, String toggleKey, PrerequisiteToggleRequest params) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = root.get("key").in(new Object[]{toggleKey}).not();
            if (StringUtils.isNotBlank((CharSequence)params.getKey())) {
                Predicate p3 = cb.equal((Expression)root.get("key"), (Object)params.getKey());
                return query.where((Expression)cb.and(new Predicate[]{p1, p2, p3})).getRestriction();
            }
            if (StringUtils.isNotBlank((CharSequence)params.getLikeNameAndKey())) {
                Predicate p3 = cb.like((Expression)root.get("name"), "%" + params.getLikeNameAndKey() + "%");
                Predicate p4 = cb.like((Expression)root.get("key"), "%" + params.getLikeNameAndKey() + "%");
                return query.where(new Predicate[]{cb.and((Expression)p1, (Expression)p2), cb.or((Expression)p3, (Expression)p4)}).getRestriction();
            }
            return query.where((Expression)cb.and((Expression)p1, (Expression)p2)).getRestriction();
        };
        return this.toggleRepository.findAll((Specification)spec);
    }

    private List<Targeting> getNonSelfTargetingList(String projectKey, String environmentKey, String toggleKey) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = cb.equal((Expression)root.get("environmentKey"), (Object)environmentKey);
            Predicate p3 = root.get("toggleKey").in(new Object[]{toggleKey}).not();
            return query.where((Expression)cb.and(new Predicate[]{p1, p2, p3})).getRestriction();
        };
        return this.targetingRepository.findAll((Specification)spec);
    }

    @Generated
    public TargetingService(TargetingRepository targetingRepository, SegmentRepository segmentRepository, TargetingSegmentRepository targetingSegmentRepository, TargetingVersionRepository targetingVersionRepository, VariationHistoryRepository variationHistoryRepository, EnvironmentRepository environmentRepository, ApprovalRecordRepository approvalRecordRepository, TargetingSketchRepository targetingSketchRepository, ToggleRepository toggleRepository, PrerequisiteRepository prerequisiteRepository, ChangeLogService changeLogService, ToggleControlConfService toggleControlConfService, MetricService metricService, AppConfig appConfig, EntityManager entityManager) {
        this.targetingRepository = targetingRepository;
        this.segmentRepository = segmentRepository;
        this.targetingSegmentRepository = targetingSegmentRepository;
        this.targetingVersionRepository = targetingVersionRepository;
        this.variationHistoryRepository = variationHistoryRepository;
        this.environmentRepository = environmentRepository;
        this.approvalRecordRepository = approvalRecordRepository;
        this.targetingSketchRepository = targetingSketchRepository;
        this.toggleRepository = toggleRepository;
        this.prerequisiteRepository = prerequisiteRepository;
        this.changeLogService = changeLogService;
        this.toggleControlConfService = toggleControlConfService;
        this.metricService = metricService;
        this.appConfig = appConfig;
        this.entityManager = entityManager;
    }
}

