/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.ToggleControlConf;
import io.featureprobe.api.dao.repository.ToggleControlConfRepository;
import io.featureprobe.api.service.MetricService;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ToggleControlConfService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToggleControlConfService.class);
    ToggleControlConfRepository toggleControlConfRepository;
    MetricService metricService;
    @PersistenceContext
    public EntityManager entityManager;

    private ToggleControlConf createDefaultByTargeting(Targeting targeting) {
        ToggleControlConf controlConf = new ToggleControlConf();
        controlConf.setProjectKey(targeting.getProjectKey());
        controlConf.setEnvironmentKey(targeting.getEnvironmentKey());
        controlConf.setToggleKey(targeting.getToggleKey());
        controlConf.setTrackAccessEvents(false);
        controlConf.setLastModified(new Date());
        return controlConf;
    }

    public ToggleControlConf queryToggleControlConf(Targeting targeting) {
        ToggleControlConf toggleControlConf = this.toggleControlConfRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(targeting.getProjectKey(), targeting.getEnvironmentKey(), targeting.getToggleKey()).orElse(this.createDefaultByTargeting(targeting));
        return toggleControlConf;
    }

    @Transactional(rollbackFor={Exception.class})
    public ToggleControlConf updateTrackAccessEvents(Targeting latestTargeting, Boolean trackAccessEvents) {
        ToggleControlConf toggleControlConf = this.queryToggleControlConf(latestTargeting);
        if (trackAccessEvents != null) {
            if (toggleControlConf.isTrackAccessEvents() == trackAccessEvents.booleanValue()) {
                return toggleControlConf;
            }
            toggleControlConf.setTrackAccessEvents(trackAccessEvents.booleanValue());
            Date now = new Date();
            if (trackAccessEvents.booleanValue()) {
                toggleControlConf.setTrackStartTime(now);
                toggleControlConf.setTrackEndTime(null);
            } else {
                toggleControlConf.setTrackEndTime(now);
            }
            this.metricService.updateMetricIteration(latestTargeting.getProjectKey(), latestTargeting.getEnvironmentKey(), latestTargeting.getToggleKey(), trackAccessEvents, now);
        }
        toggleControlConf.setLastModified(new Date());
        this.toggleControlConfRepository.save((Object)toggleControlConf);
        return toggleControlConf;
    }

    @Generated
    public ToggleControlConfService(ToggleControlConfRepository toggleControlConfRepository, MetricService metricService, EntityManager entityManager) {
        this.toggleControlConfRepository = toggleControlConfRepository;
        this.metricService = metricService;
        this.entityManager = entityManager;
    }
}

