/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.FeatureProbe;
import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.component.SpringBeanManager;
import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.SketchStatusEnum;
import io.featureprobe.api.base.enums.ToggleReleaseStatusEnum;
import io.featureprobe.api.base.enums.TrafficCacheTypeEnum;
import io.featureprobe.api.base.enums.VisitFilter;
import io.featureprobe.api.base.model.PaginationRequest;
import io.featureprobe.api.config.AppConfig;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Project;
import io.featureprobe.api.dao.entity.Tag;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.TargetingSketch;
import io.featureprobe.api.dao.entity.TargetingVersion;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dao.entity.ToggleTagRelation;
import io.featureprobe.api.dao.entity.TrafficCache;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.exception.ResourceOverflowException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.ProjectRepository;
import io.featureprobe.api.dao.repository.TagRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dao.repository.TargetingSketchRepository;
import io.featureprobe.api.dao.repository.TargetingVersionRepository;
import io.featureprobe.api.dao.repository.ToggleRepository;
import io.featureprobe.api.dao.repository.ToggleTagRepository;
import io.featureprobe.api.dao.repository.TrafficCacheRepository;
import io.featureprobe.api.dao.repository.TrafficRepository;
import io.featureprobe.api.dao.utils.PageRequestUtil;
import io.featureprobe.api.dto.ToggleCreateRequest;
import io.featureprobe.api.dto.ToggleItemResponse;
import io.featureprobe.api.dto.ToggleResponse;
import io.featureprobe.api.dto.ToggleSearchRequest;
import io.featureprobe.api.dto.ToggleUpdateRequest;
import io.featureprobe.api.mapper.ToggleMapper;
import io.featureprobe.api.service.ChangeLogService;
import io.featureprobe.api.service.TargetingService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ToggleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToggleService.class);
    private AppConfig appConfig;
    private ToggleRepository toggleRepository;
    private TagRepository tagRepository;
    private TargetingRepository targetingRepository;
    private EnvironmentRepository environmentRepository;
    private TrafficRepository trafficRepository;
    private TargetingSketchRepository targetingSketchRepository;
    private TrafficCacheRepository trafficCacheRepository;
    private ToggleTagRepository toggleTagRepository;
    private ChangeLogService changeLogService;
    private ProjectRepository projectRepository;
    private TargetingService targetingService;
    private TargetingVersionRepository targetingVersionRepository;
    @PersistenceContext
    public EntityManager entityManager;
    private static final String LIMITER_TOGGLE_KEY = "FeatureProbe_toggle_limiter";

    @Transactional(rollbackFor={Exception.class})
    public ToggleResponse create(String projectKey, ToggleCreateRequest createRequest) {
        this.validateLimit(projectKey);
        Toggle toggle = this.createToggle(projectKey, createRequest);
        this.targetingService.createDefaultTargetingEntities(projectKey, toggle);
        return ToggleMapper.INSTANCE.entityToResponse(toggle, this.appConfig.getToggleDeadline());
    }

    protected Toggle createToggle(String projectKey, ToggleCreateRequest createRequest) {
        Toggle toggle = ToggleMapper.INSTANCE.requestToEntity(createRequest);
        toggle.setProjectKey(projectKey);
        this.setToggleTagRefs(toggle, createRequest.getTags());
        return (Toggle)this.toggleRepository.save((Object)toggle);
    }

    @Transactional(rollbackFor={Exception.class})
    public ToggleResponse update(String projectKey, String toggleKey, ToggleUpdateRequest updateRequest) {
        Toggle toggle = (Toggle)this.toggleRepository.findByProjectKeyAndKey(projectKey, toggleKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TOGGLE, toggleKey));
        if (StringUtils.isNotBlank((CharSequence)updateRequest.getName()) && !StringUtils.equals((CharSequence)toggle.getName(), (CharSequence)updateRequest.getName())) {
            this.validateName(projectKey, updateRequest.getName());
        }
        ToggleMapper.INSTANCE.mapEntity(updateRequest, toggle);
        if (CollectionUtils.isNotEmpty(updateRequest.getTags())) {
            this.setToggleTagRefs(toggle, updateRequest.getTags());
        }
        this.toggleRepository.save((Object)toggle);
        return ToggleMapper.INSTANCE.entityToResponse(toggle, this.appConfig.getToggleDeadline());
    }

    @Transactional(rollbackFor={Exception.class})
    @Archived
    public ToggleResponse offline(String projectKey, String toggleKey) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        Toggle toggle = (Toggle)this.toggleRepository.findByProjectKeyAndKeyAndArchived(projectKey, toggleKey, Boolean.valueOf(false)).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TOGGLE, toggleKey));
        for (Environment environment : project.getEnvironments()) {
            this.changeLogService.create(environment, ChangeLogType.CHANGE);
        }
        toggle.setArchived(true);
        return ToggleMapper.INSTANCE.entityToResponse((Toggle)this.toggleRepository.save((Object)toggle), this.appConfig.getToggleDeadline());
    }

    @Transactional(rollbackFor={Exception.class})
    @Archived
    public ToggleResponse restore(String projectKey, String toggleKey) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        Toggle toggle = (Toggle)this.toggleRepository.findByProjectKeyAndKeyAndArchived(projectKey, toggleKey, Boolean.valueOf(true)).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TOGGLE, toggleKey));
        for (Environment environment : project.getEnvironments()) {
            this.changeLogService.create(environment, ChangeLogType.CHANGE);
        }
        toggle.setArchived(false);
        return ToggleMapper.INSTANCE.entityToResponse((Toggle)this.toggleRepository.save((Object)toggle), this.appConfig.getToggleDeadline());
    }

    @Archived
    public Page<ToggleItemResponse> list(String projectKey, ToggleSearchRequest searchRequest) {
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getEnvironmentKey())) {
            Set<String> keys;
            Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKeyAndArchived(projectKey, searchRequest.getEnvironmentKey(), Boolean.valueOf(false)).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, searchRequest.getEnvironmentKey()));
            TreeSet<String> toggleKeys = new TreeSet<String>();
            boolean isPrecondition = false;
            if (Objects.nonNull(searchRequest.getDisabled())) {
                isPrecondition = true;
                keys = this.queryToggleKeysByDisabled(projectKey, searchRequest.getEnvironmentKey(), searchRequest.getDisabled());
                this.retainAllKeys(toggleKeys, keys);
            }
            if (CollectionUtils.isNotEmpty(searchRequest.getTags())) {
                isPrecondition = true;
                keys = this.queryToggleKeysByTags(searchRequest.getTags());
                this.retainAllKeys(toggleKeys, keys);
            }
            if (Objects.nonNull(searchRequest.getVisitFilter())) {
                isPrecondition = true;
                keys = this.queryToggleKeysByVisited(searchRequest.getVisitFilter(), projectKey, environment);
                this.retainAllKeys(toggleKeys, keys);
            }
            if (CollectionUtils.isNotEmpty(searchRequest.getReleaseStatusList())) {
                isPrecondition = true;
                keys = this.queryToggleKeysByReleaseStatus(projectKey, searchRequest.getEnvironmentKey(), searchRequest.getReleaseStatusList());
                this.retainAllKeys(toggleKeys, keys);
            }
            if (BooleanUtils.isTrue((Boolean)searchRequest.getRelated())) {
                isPrecondition = true;
                keys = this.queryToggleKeysByRelatedToMe(projectKey, environment.getKey());
                this.retainAllKeys(toggleKeys, keys);
            }
            Page<Toggle> togglePage = this.compoundQuery(projectKey, searchRequest, toggleKeys, isPrecondition);
            keys = togglePage.getContent().stream().map(Toggle::getKey).collect(Collectors.toSet());
            Map<String, Targeting> targetingMap = this.queryTargetingMap(projectKey, searchRequest.getEnvironmentKey(), keys);
            Map<String, TargetingSketch> targetingSketchMap = this.queryNewestTargetingSketchMap(projectKey, searchRequest.getEnvironmentKey(), keys);
            Map<String, TrafficCache> metricsCacheMap = this.queryTrafficCacheMap(projectKey, searchRequest.getEnvironmentKey(), keys);
            Map<String, Set<String>> tagMap = this.queryTagMap(keys);
            return togglePage.map(item -> this.entityToItemResponse((Toggle)item, projectKey, searchRequest.getEnvironmentKey(), targetingMap, targetingSketchMap, metricsCacheMap, tagMap));
        }
        Page togglePage = this.toggleRepository.findAllByProjectKeyAndArchived(projectKey, Boolean.valueOf(false), PageRequestUtil.toPageable((PaginationRequest)searchRequest, (Sort.Direction)Sort.Direction.DESC, (String)"createdTime"));
        return togglePage.map(item -> ToggleMapper.INSTANCE.entityToItemResponse((Toggle)item, this.appConfig.getToggleDeadline()));
    }

    protected Set<String> queryToggleKeysByRelatedToMe(String projectKey, String environmentKey) {
        Specification specification = this.getRelatedToMeToggleKeySpecification(projectKey, environmentKey);
        Set<String> toggleKeys = this.targetingVersionRepository.findAll(specification).stream().map(TargetingVersion::getToggleKey).collect(Collectors.toSet());
        Specification withoutEnvironmentKeySpec = this.getRelatedToMeToggleKeySpecification(projectKey, null);
        toggleKeys.addAll(this.toggleRepository.findAll(withoutEnvironmentKeySpec).stream().map(Toggle::getKey).collect(Collectors.toSet()));
        toggleKeys.addAll(this.targetingRepository.findAll(specification).stream().map(Targeting::getToggleKey).collect(Collectors.toSet()));
        return toggleKeys;
    }

    private Specification getRelatedToMeToggleKeySpecification(String projectKey, String environmentKey) {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            if (StringUtils.isNotBlank((CharSequence)environmentKey)) {
                Predicate p2 = cb.equal((Expression)root.get("environmentKey"), (Object)environmentKey);
                cb.and((Expression)p1, (Expression)p2);
            } else {
                cb.and(new Predicate[]{p1});
            }
            Predicate p3 = cb.equal((Expression)root.get("modifiedBy"), (Object)TokenHelper.getUserId());
            Predicate p4 = cb.equal((Expression)root.get("createdBy"), (Object)TokenHelper.getUserId());
            return query.where((Expression)cb.and(new Predicate[]{cb.or((Expression)p3, (Expression)p4)})).getRestriction();
        };
    }

    private void validateLimit(String projectKey) {
        long total = this.toggleRepository.countByProjectKey(projectKey);
        FPUser user = new FPUser(String.valueOf(TokenHelper.getUserId()));
        user.with("account", TokenHelper.getAccount());
        double limitNum = ((FeatureProbe)SpringBeanManager.getBeanByType(FeatureProbe.class)).numberValue(LIMITER_TOGGLE_KEY, user, -1.0);
        if (limitNum > 0.0 && (double)total >= limitNum) {
            throw new ResourceOverflowException(ResourceType.TOGGLE);
        }
    }

    private void validateName(String projectKey, String name) {
        if (this.toggleRepository.existsByProjectKeyAndName(projectKey, name)) {
            throw new ResourceConflictException(ResourceType.TOGGLE);
        }
    }

    private void setToggleTagRefs(Toggle toggle, List<String> tagNames) {
        Set tags = this.tagRepository.findByProjectKeyAndNameIn(toggle.getProjectKey(), tagNames);
        toggle.setTags(tags);
    }

    private Map<String, Set<String>> queryTagMap(Set<String> toggleKeys) {
        List toggleTags = this.toggleTagRepository.findByToggleKeyIn(toggleKeys);
        Set tagIds = toggleTags.stream().map(ToggleTagRelation::getTagId).collect(Collectors.toSet());
        List tags = this.tagRepository.findAllById(tagIds);
        Map<Long, String> tagMap = tags.stream().collect(Collectors.toMap(AbstractAuditEntity::getId, Tag::getName));
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>(10);
        toggleTags.stream().forEach(toggleTag -> {
            if (res.containsKey(toggleTag.getToggleKey())) {
                ((Set)res.get(toggleTag.getToggleKey())).add(tagMap.get(toggleTag.getTagId()));
            } else {
                res.put(toggleTag.getToggleKey(), new HashSet(Collections.singletonList(tagMap.get(toggleTag.getTagId()))));
            }
        });
        return res;
    }

    private Map<String, TargetingSketch> queryNewestTargetingSketchMap(String projectKey, String environmentKey, Set<String> toggleKeys) {
        List targetingSketches = this.targetingSketchRepository.findByProjectKeyAndEnvironmentKeyAndStatusAndToggleKeyIn(projectKey, environmentKey, SketchStatusEnum.PENDING, toggleKeys);
        return targetingSketches.stream().collect(Collectors.toMap(TargetingSketch::uniqueKey, Function.identity(), (x, y) -> x));
    }

    private Map<String, Targeting> queryTargetingMap(String projectKey, String environmentKey, Set<String> toggleKeys) {
        List targetingList = this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKeyIn(projectKey, environmentKey, toggleKeys);
        return targetingList.stream().collect(Collectors.toMap(Targeting::uniqueKey, Function.identity(), (x, y) -> x));
    }

    private Page<Toggle> compoundQuery(String projectKey, ToggleSearchRequest searchRequest, Set<String> toggleKeys, boolean isPrecondition) {
        Specification & Serializable resultSpec = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicateListAnd = new ArrayList<Predicate>();
            ArrayList<Predicate> predicateListOr = new ArrayList<Predicate>();
            predicateListAnd.add(cb.equal((Expression)root.get("projectKey"), (Object)projectKey));
            if (searchRequest.isArchived()) {
                predicateListAnd.add(cb.equal((Expression)root.get("archived"), (Object)Boolean.TRUE));
            } else {
                predicateListAnd.add(cb.equal((Expression)root.get("archived"), (Object)Boolean.FALSE));
            }
            if (StringUtils.isNotBlank((CharSequence)searchRequest.getKeyword())) {
                predicateListOr.add(cb.like((Expression)root.get("name"), "%" + searchRequest.getKeyword() + "%"));
                predicateListOr.add(cb.like((Expression)root.get("key"), "%" + searchRequest.getKeyword() + "%"));
                predicateListOr.add(cb.like((Expression)root.get("desc"), "%" + searchRequest.getKeyword() + "%"));
            }
            if (isPrecondition) {
                predicateListAnd.add(root.get("key").in((Collection)toggleKeys));
            }
            if (!Objects.isNull(searchRequest.getPermanent())) {
                predicateListAnd.add(cb.equal((Expression)root.get("permanent"), (Object)searchRequest.getPermanent()));
            }
            if (predicateListOr.size() > 0) {
                return query.where(new Predicate[]{cb.and(predicateListAnd.toArray(new Predicate[predicateListAnd.size()])), cb.or(predicateListOr.toArray(new Predicate[predicateListOr.size()]))}).getRestriction();
            }
            return query.where((Expression)cb.and(predicateListAnd.toArray(new Predicate[predicateListAnd.size()]))).getRestriction();
        };
        PageRequest pageable = PageRequest.of((int)searchRequest.getPageIndex(), (int)searchRequest.getPageSize(), (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdTime"});
        return this.toggleRepository.findAll((Specification)resultSpec, (Pageable)pageable);
    }

    private void retainAllKeys(Set<String> keys, Set<String> targets) {
        if (keys.isEmpty()) {
            keys.addAll(targets);
        } else {
            keys.retainAll(targets);
        }
    }

    private Set<String> queryToggleKeysByDisabled(String projectKey, String environmentKey, Boolean disabled) {
        List targetingList = this.targetingRepository.findAllByProjectKeyAndEnvironmentKeyAndDisabled(projectKey, environmentKey, disabled.booleanValue());
        return targetingList.stream().map(Targeting::getToggleKey).collect(Collectors.toSet());
    }

    private Set<String> queryToggleKeysByReleaseStatus(String projectKey, String environmentKey, List<ToggleReleaseStatusEnum> statusList) {
        List targetingList = this.targetingRepository.findAllByProjectKeyAndEnvironmentKeyAndStatusIn(projectKey, environmentKey, statusList);
        return targetingList.stream().map(Targeting::getToggleKey).collect(Collectors.toSet());
    }

    private Set<String> queryToggleKeysByTags(List<String> tagNames) {
        List tags = this.tagRepository.findByNameIn(tagNames);
        Set tagIds = tags.stream().map(AbstractAuditEntity::getId).collect(Collectors.toSet());
        List toggleTags = this.toggleTagRepository.findByTagIdIn(tagIds);
        return toggleTags.stream().map(ToggleTagRelation::getToggleKey).collect(Collectors.toSet());
    }

    private Set<String> queryToggleKeysByVisited(VisitFilter visitFilter, String projectKey, Environment environment) {
        switch (visitFilter) {
            case IN_WEEK_VISITED: {
                return this.weekVisitedToggleKeys(environment);
            }
            case OUT_WEEK_VISITED: {
                return this.lastVisitBeforeWeekToggleKeys(environment);
            }
            case NOT_VISITED: {
                return this.neverVisited(projectKey, environment);
            }
        }
        return new HashSet<String>();
    }

    private Set<String> allVisitedToggleKeys(Environment environment) {
        return this.trafficRepository.findAllAccessedToggleKey(environment.getServerSdkKey(), environment.getClientSdkKey());
    }

    private Set<String> weekVisitedToggleKeys(Environment environment) {
        Date lastWeek = Date.from(LocalDateTime.now().minusDays(7L).atZone(ZoneId.systemDefault()).toInstant());
        return this.trafficRepository.findAllAccessedToggleKeyGreaterThanOrEqualToEndDate(environment.getServerSdkKey(), environment.getClientSdkKey(), lastWeek);
    }

    private Set<String> lastVisitBeforeWeekToggleKeys(Environment environment) {
        Set<String> allVisitedKeys = this.allVisitedToggleKeys(environment);
        Set<String> weekVisitedKeys = this.weekVisitedToggleKeys(environment);
        allVisitedKeys.removeAll(weekVisitedKeys);
        return allVisitedKeys;
    }

    private Set<String> neverVisited(String projectKey, Environment environment) {
        Set<String> allVisitedKeys = this.allVisitedToggleKeys(environment);
        Specification & Serializable notSpec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("projectKey"), (Object)projectKey);
            Predicate p2 = root.get("key").in((Collection)allVisitedKeys).not();
            return query.where((Expression)cb.and((Expression)p1, (Expression)p2)).getRestriction();
        };
        List toggles = this.toggleRepository.findAll((Specification)notSpec);
        return toggles.stream().map(Toggle::getKey).collect(Collectors.toSet());
    }

    private ToggleItemResponse entityToItemResponse(Toggle toggle, String projectKey, String environmentKey, Map<String, Targeting> targetingMap, Map<String, TargetingSketch> targetingSketchMap, Map<String, TrafficCache> metricsCacheMap, Map<String, Set<String>> tagMap) {
        TargetingSketch sketch;
        ToggleItemResponse toggleItem = ToggleMapper.INSTANCE.entityToItemResponse(toggle, this.appConfig.getToggleDeadline());
        toggleItem.setTags(tagMap.get(toggle.getKey()));
        toggleItem.setDisabled(targetingMap.get(this.uniqueKey(projectKey, environmentKey, toggle.getKey())).isDisabled());
        toggleItem.setReleaseStatus(targetingMap.get(this.uniqueKey(projectKey, environmentKey, toggle.getKey())).getStatus());
        if (ObjectUtils.isNotEmpty((Object)metricsCacheMap.get(toggle.getKey()))) {
            toggleItem.setVisitedTime(metricsCacheMap.get(toggle.getKey()).getStartDate());
        }
        if (ObjectUtils.isNotEmpty((Object)(sketch = targetingSketchMap.get(this.uniqueKey(projectKey, environmentKey, toggle.getKey()))))) {
            toggleItem.setLocked(this.locked(sketch));
            toggleItem.setLockedBy(sketch.getCreatedBy().getAccount());
            toggleItem.setLockedTime(sketch.getCreatedTime());
        }
        return toggleItem;
    }

    private String uniqueKey(String projectKey, String environmentKey, String toggleKey) {
        return projectKey + "&" + environmentKey + "&" + toggleKey;
    }

    private boolean locked(TargetingSketch targetingSketch) {
        return targetingSketch.getStatus() == SketchStatusEnum.PENDING;
    }

    private Map<String, TrafficCache> queryTrafficCacheMap(String projectKey, String environmentKey, Set<String> toggleKeys) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).get();
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p0 = root.get("toggleKey").in((Collection)toggleKeys);
            Predicate p1 = cb.equal((Expression)root.get("sdkKey"), (Object)environment.getServerSdkKey());
            Predicate p2 = cb.equal((Expression)root.get("sdkKey"), (Object)environment.getClientSdkKey());
            Predicate p3 = cb.equal((Expression)root.get("type"), (Object)TrafficCacheTypeEnum.EVALUATION);
            return query.where(new Predicate[]{cb.and((Expression)p0, (Expression)p3), cb.or((Expression)p1, (Expression)p2)}).getRestriction();
        };
        List trafficCaches = this.trafficCacheRepository.findAll((Specification)spec);
        return trafficCaches.stream().collect(Collectors.toMap(TrafficCache::getToggleKey, Function.identity()));
    }

    @Archived
    public ToggleResponse queryByKey(String projectKey, String toggleKey) {
        Toggle toggle = (Toggle)this.toggleRepository.findByProjectKeyAndKey(projectKey, toggleKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.TOGGLE, toggleKey));
        return ToggleMapper.INSTANCE.entityToResponse(toggle, this.appConfig.getToggleDeadline());
    }

    @Generated
    public ToggleService(AppConfig appConfig, ToggleRepository toggleRepository, TagRepository tagRepository, TargetingRepository targetingRepository, EnvironmentRepository environmentRepository, TrafficRepository trafficRepository, TargetingSketchRepository targetingSketchRepository, TrafficCacheRepository trafficCacheRepository, ToggleTagRepository toggleTagRepository, ChangeLogService changeLogService, ProjectRepository projectRepository, TargetingService targetingService, TargetingVersionRepository targetingVersionRepository, EntityManager entityManager) {
        this.appConfig = appConfig;
        this.toggleRepository = toggleRepository;
        this.tagRepository = tagRepository;
        this.targetingRepository = targetingRepository;
        this.environmentRepository = environmentRepository;
        this.trafficRepository = trafficRepository;
        this.targetingSketchRepository = targetingSketchRepository;
        this.trafficCacheRepository = trafficCacheRepository;
        this.toggleTagRepository = toggleTagRepository;
        this.changeLogService = changeLogService;
        this.projectRepository = projectRepository;
        this.targetingService = targetingService;
        this.targetingVersionRepository = targetingVersionRepository;
        this.entityManager = entityManager;
    }
}

