/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.aop;

import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.hook.Action;
import io.featureprobe.api.base.hook.Hook;
import io.featureprobe.api.base.hook.IHookQueue;
import io.featureprobe.api.base.model.HookContext;
import io.featureprobe.api.base.tenant.TenantContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Aspect
@Component
public class HookAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookAspect.class);
    @Resource
    IHookQueue hookQueue;

    @Pointcut(value="@annotation(io.featureprobe.api.base.hook.Hook)")
    public void hook() {
    }

    @Around(value="hook()")
    public Object around(ProceedingJoinPoint jp) throws Throwable {
        Hook webHookAnnotation = this.getMethodAnnotation((JoinPoint)jp, Hook.class);
        Action action = webHookAnnotation.action();
        io.featureprobe.api.base.hook.Resource resource = webHookAnnotation.resource();
        HookContext context = new HookContext(resource, action);
        context.setOperator(TokenHelper.getAccount());
        context.setOrganizationId(Long.valueOf(Long.parseLong(TenantContext.getCurrentTenant())));
        Object ret = jp.proceed();
        this.composeParam(jp, context);
        context.setResponse(ret);
        this.hookQueue.push(context);
        return ret;
    }

    private void composeParam(ProceedingJoinPoint jp, HookContext context) {
        Long id;
        String segmentKey;
        String toggleKey;
        String environmentKey;
        String projectKey;
        Object requestBody = this.getRequestBody(jp);
        if (Objects.nonNull(requestBody)) {
            context.setRequest(requestBody);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectKey = this.getProjectKeyArg(jp)))) {
            context.setProjectKey(projectKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(environmentKey = this.getEnvironmentKeyArg(jp)))) {
            context.setEnvironmentKey(environmentKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(toggleKey = this.getToggleKeyArg(jp)))) {
            context.setToggleKey(toggleKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(segmentKey = this.getSegmentKeyArg(jp)))) {
            context.setSegmentKey(segmentKey);
        }
        if (Objects.nonNull(id = this.getIdArg(jp))) {
            context.setId(id);
        }
    }

    private Object getRequestBody(ProceedingJoinPoint jp) {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] args = jp.getArgs();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof RequestBody)) continue;
                return args[i];
            }
        }
        return null;
    }

    private String getProjectKeyArg(ProceedingJoinPoint jp) {
        Object projectKey = this.getPathArg(jp, "projectKey");
        if (Objects.isNull(projectKey)) {
            return null;
        }
        return String.valueOf(projectKey);
    }

    private String getEnvironmentKeyArg(ProceedingJoinPoint jp) {
        Object environmentKey = this.getPathArg(jp, "environmentKey");
        if (Objects.isNull(environmentKey)) {
            return null;
        }
        return String.valueOf(environmentKey);
    }

    private String getToggleKeyArg(ProceedingJoinPoint jp) {
        Object toggleKey = this.getPathArg(jp, "toggleKey");
        if (Objects.isNull(toggleKey)) {
            return null;
        }
        return String.valueOf(toggleKey);
    }

    private String getSegmentKeyArg(ProceedingJoinPoint jp) {
        Object segmentKey = this.getPathArg(jp, "segmentKey");
        if (Objects.isNull(segmentKey)) {
            return null;
        }
        return String.valueOf(segmentKey);
    }

    private Long getIdArg(ProceedingJoinPoint jp) {
        Object idArg = this.getPathArg(jp, "id");
        Long id = null;
        if (Objects.isNull(idArg)) {
            return null;
        }
        try {
            id = (Long)idArg;
        }
        catch (Exception e) {
            return null;
        }
        return id;
    }

    private Object getPathArg(ProceedingJoinPoint jp, String name) {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] args = jp.getArgs();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof PathVariable) || !((PathVariable)annotation).value().equals(name)) continue;
                return args[i];
            }
        }
        return null;
    }

    private <T extends Annotation> T getMethodAnnotation(JoinPoint joinPoint, Class<T> clazz) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        return method.getAnnotation(clazz);
    }
}

