/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccessTokenAuthenticationToken;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class AccessTokenAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessTokenAuthenticationProcessingFilter.class);
    private static final String ACCESS_TOKEN_HEADER = "Authorization";

    protected AccessTokenAuthenticationProcessingFilter() {
        super(request -> {
            String authorization = request.getHeader(ACCESS_TOKEN_HEADER);
            return StringUtils.isNotBlank((CharSequence)authorization) && authorization.trim().startsWith("api-");
        });
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String token = StringUtils.trim((String)request.getHeader(ACCESS_TOKEN_HEADER));
        return this.getAuthenticationManager().authenticate((Authentication)new AccessTokenAuthenticationToken(token));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

