/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccountValidator;
import io.featureprobe.api.auth.AuthenticatedMember;
import io.featureprobe.api.auth.OrganizationEmptyException;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import io.featureprobe.api.base.enums.MemberSourceEnum;
import io.featureprobe.api.base.enums.MemberStatusEnum;
import io.featureprobe.api.base.enums.OperationType;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.OperationLog;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.repository.OrganizationRepository;
import io.featureprobe.api.service.MemberService;
import io.featureprobe.api.service.OperationLogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component(value="common")
public class CommonAccountValidator
implements AccountValidator {
    private MemberService memberService;
    private OrganizationRepository organizationRepository;
    private OperationLogService operationLogService;

    @Override
    public Authentication authenticate(Authentication authentication) {
        UserPasswordAuthenticationToken token = (UserPasswordAuthenticationToken)authentication;
        if (StringUtils.isNotBlank((CharSequence)token.getAccount()) && StringUtils.isNotBlank((CharSequence)token.getPassword())) {
            Optional<Member> memberOptional = this.memberService.findByAccount(token.getAccount());
            OperationLog log = new OperationLog(OperationType.LOGIN.name() + "_" + token.getSource(), token.getAccount());
            if (!memberOptional.isPresent() || this.isAccessTokenNumber(memberOptional)) {
                throw new UsernameNotFoundException("Account not found.");
            }
            Member member = memberOptional.get();
            Member immutableMember = new Member();
            BeanUtils.copyProperties((Object)member, (Object)immutableMember);
            if (!MemberStatusEnum.ACTIVE.name().equals(member.getStatus().name())) {
                throw new BadCredentialsException("Credentials are incorrect.");
            }
            if (CollectionUtils.isEmpty((Collection)member.getOrganizations())) {
                if (token.isInitializeOrganization()) {
                    Organization organization = Organization.createDefaultOrganization();
                    organization = (Organization)this.organizationRepository.save((Object)organization);
                    ArrayList<OrganizationMember> organizationMembers = new ArrayList<OrganizationMember>(1);
                    organizationMembers.add(new OrganizationMember(organization, member, OrganizationRoleEnum.OWNER, Boolean.valueOf(true), null));
                    member.setOrganizationMembers(organizationMembers);
                    member = this.memberService.save(member);
                } else {
                    throw new OrganizationEmptyException("Organization is empty.");
                }
            }
            boolean passwordMatched = new BCryptPasswordEncoder().matches((CharSequence)token.getPassword(), member.getPassword());
            boolean organizationChecked = true;
            OrganizationMemberModel organizationMemberModel = null;
            if (StringUtils.isNotBlank((CharSequence)token.getOrganizationId())) {
                Long organizationId = Long.parseLong(token.getOrganizationId());
                for (OrganizationMember organizationMember : member.getOrganizationMembers()) {
                    if (!organizationMember.getOrganization().getId().equals(organizationId)) continue;
                    Organization organization = organizationMember.getOrganization();
                    organizationMemberModel = new OrganizationMemberModel(organization.getId(), organization.getName(), organizationMember.getRole());
                }
                if (Objects.isNull(organizationMemberModel)) {
                    throw new BadCredentialsException("Credentials are incorrect.");
                }
            }
            if (Objects.isNull(organizationMemberModel)) {
                OrganizationMember organizationMember = (OrganizationMember)member.getOrganizationMembers().get(0);
                organizationMemberModel = new OrganizationMemberModel(organizationMember.getOrganization().getId(), organizationMember.getOrganization().getName(), organizationMember.getRole());
            }
            if (organizationChecked && passwordMatched) {
                this.memberService.updateLoginTime(member, organizationMemberModel.getOrganizationId());
                this.operationLogService.save(log);
                return new UserPasswordAuthenticationToken(AuthenticatedMember.create(immutableMember, organizationMemberModel), Collections.emptyList());
            }
        }
        throw new BadCredentialsException("Credentials are incorrect.");
    }

    private boolean isAccessTokenNumber(Optional<Member> member) {
        return StringUtils.equalsIgnoreCase((CharSequence)member.get().getSource(), (CharSequence)MemberSourceEnum.ACCESS_TOKEN.name());
    }

    @Generated
    public CommonAccountValidator(MemberService memberService, OrganizationRepository organizationRepository, OperationLogService operationLogService) {
        this.memberService = memberService;
        this.organizationRepository = organizationRepository;
        this.operationLogService = operationLogService;
    }
}

