/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AuthenticatedMember;
import io.featureprobe.api.auth.GuestAuthenticationToken;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import io.featureprobe.api.base.enums.MemberSourceEnum;
import io.featureprobe.api.base.enums.OperationType;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.OperationLog;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.service.GuestService;
import io.featureprobe.api.service.MemberService;
import io.featureprobe.api.service.OperationLogService;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class GuestAuthenticationProvider
implements AuthenticationProvider {
    private MemberService memberService;
    private GuestService guestService;
    private OperationLogService operationLogService;

    @Transactional(rollbackFor={Exception.class})
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        GuestAuthenticationToken token = (GuestAuthenticationToken)authentication;
        Optional<Member> member = this.memberService.findByAccount(token.getAccount());
        OperationLog log = new OperationLog(OperationType.LOGIN.name() + "_" + token.getSource(), token.getAccount());
        if (member.isPresent()) {
            if (this.isAccessTokenMember(member)) {
                return null;
            }
            this.memberService.updateLoginTime(member.get(), this.getDefaultOrganizationMember(member.get()).getOrganizationId());
            this.operationLogService.save(log);
            return new UserPasswordAuthenticationToken(AuthenticatedMember.create(member.get(), this.getDefaultOrganizationMember(member.get())), Collections.emptyList());
        }
        Member newMember = this.guestService.initGuest(token.getAccount(), token.getSource());
        this.operationLogService.save(log);
        return new UserPasswordAuthenticationToken(AuthenticatedMember.create(newMember, this.getDefaultOrganizationMember(newMember)), Collections.emptyList());
    }

    private boolean isAccessTokenMember(Optional<Member> member) {
        return StringUtils.equalsIgnoreCase((CharSequence)member.get().getSource(), (CharSequence)MemberSourceEnum.ACCESS_TOKEN.name());
    }

    private OrganizationMemberModel getDefaultOrganizationMember(Member member) {
        OrganizationMember organizationMember = (OrganizationMember)member.getOrganizationMembers().get(0);
        return new OrganizationMemberModel(organizationMember.getOrganization().getId(), organizationMember.getOrganization().getName(), organizationMember.getRole());
    }

    public boolean supports(Class<?> authentication) {
        return GuestAuthenticationToken.class.isAssignableFrom(authentication);
    }

    @Generated
    public GuestAuthenticationProvider(MemberService memberService, GuestService guestService, OperationLogService operationLogService) {
        this.memberService = memberService;
        this.guestService = guestService;
        this.operationLogService = operationLogService;
    }
}

