/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.AccountValidator;
import io.featureprobe.api.auth.AuthenticatedMember;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import io.featureprobe.api.base.enums.MemberSourceEnum;
import io.featureprobe.api.base.enums.MemberStatusEnum;
import io.featureprobe.api.base.enums.OperationType;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.OperationLog;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.repository.OrganizationRepository;
import io.featureprobe.api.service.MemberService;
import io.featureprobe.api.service.OperationLogService;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component(value="ldap")
public class LdapAccountValidator
implements AccountValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapAccountValidator.class);
    private MemberService memberService;
    private OperationLogService operationLogService;
    private OrganizationRepository organizationRepository;
    private LdapTemplate ldapTemplate;
    private LdapContextSource contextSource;
    private String ldapUsernameAttribute;

    @Override
    public Authentication authenticate(Authentication authentication) {
        UserPasswordAuthenticationToken token = (UserPasswordAuthenticationToken)authentication;
        if (StringUtils.isNotBlank((CharSequence)token.getAccount()) && StringUtils.isNotBlank((CharSequence)token.getPassword())) {
            boolean ldapAuthPassCheck = this.authenticateByLdap(token);
            String memberName = token.getAccount();
            Optional<Member> memberOptional = this.memberService.findByAccount(memberName);
            if (!memberOptional.isPresent() && ldapAuthPassCheck) {
                OrganizationMemberModel defaultOrganizeMemberModel = new OrganizationMemberModel(Long.valueOf(1L), "Default Organize", OrganizationRoleEnum.WRITER);
                Organization organization = (Organization)this.organizationRepository.findById((Object)1L).get();
                Member member = new Member();
                member.setAccount(token.getAccount());
                member.setPassword(new BCryptPasswordEncoder().encode((CharSequence)UUID.randomUUID().toString()));
                member.setSource(MemberSourceEnum.PLATFORM.name());
                member.addOrganization(organization, OrganizationRoleEnum.WRITER);
                this.memberService.save(member);
                return new UserPasswordAuthenticationToken(AuthenticatedMember.create(member, defaultOrganizeMemberModel), Collections.emptyList());
            }
            OperationLog log = new OperationLog(OperationType.LOGIN.name() + "_" + token.getSource(), token.getAccount());
            Member member = memberOptional.get();
            Member immutableMember = new Member();
            BeanUtils.copyProperties((Object)member, (Object)immutableMember);
            if (!memberOptional.isPresent() || this.isAccessTokenNumber(memberOptional)) {
                throw new UsernameNotFoundException("Account not found.");
            }
            boolean passwordMatched = new BCryptPasswordEncoder().matches((CharSequence)token.getPassword(), member.getPassword());
            OrganizationMember organizationMember = (OrganizationMember)member.getOrganizationMembers().get(0);
            OrganizationMemberModel organizationMemberModel = new OrganizationMemberModel(organizationMember.getOrganization().getId(), organizationMember.getOrganization().getName(), organizationMember.getRole());
            if ((ldapAuthPassCheck || passwordMatched) && MemberStatusEnum.ACTIVE.name().equals(member.getStatus().name())) {
                member.setVisitedTime(new Date());
                this.memberService.save(member);
                this.operationLogService.save(log);
                return new UserPasswordAuthenticationToken(AuthenticatedMember.create(immutableMember, organizationMemberModel), Collections.emptyList());
            }
            throw new BadCredentialsException("Credentials are incorrect.");
        }
        throw new BadCredentialsException("Credentials are incorrect.");
    }

    private boolean authenticateByLdap(UserPasswordAuthenticationToken token) {
        try {
            this.ldapTemplate.authenticate((LdapQuery)LdapQueryBuilder.query().where(this.ldapUsernameAttribute).is(token.getAccount()), token.getPassword());
            return true;
        }
        catch (Exception e) {
            log.error("err when authenticate on ldap server {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean isAccessTokenNumber(Optional<Member> member) {
        return StringUtils.equalsIgnoreCase((CharSequence)member.get().getSource(), (CharSequence)MemberSourceEnum.ACCESS_TOKEN.name());
    }

    @Generated
    public LdapAccountValidator(MemberService memberService, OperationLogService operationLogService, OrganizationRepository organizationRepository, LdapTemplate ldapTemplate, LdapContextSource contextSource, String ldapUsernameAttribute) {
        this.memberService = memberService;
        this.operationLogService = operationLogService;
        this.organizationRepository = organizationRepository;
        this.ldapTemplate = ldapTemplate;
        this.contextSource = contextSource;
        this.ldapUsernameAttribute = ldapUsernameAttribute;
    }
}

