/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import io.featureprobe.api.auth.OrganizationEmptyException;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.base.util.JsonMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class LoginFailureHandler
implements AuthenticationFailureHandler {
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        BaseResponse res = new BaseResponse(HttpStatus.FORBIDDEN.name().toLowerCase(), HttpStatus.FORBIDDEN.getReasonPhrase());
        response.setStatus(HttpStatus.FORBIDDEN.value());
        if (exception instanceof OrganizationEmptyException) {
            response.setStatus(HttpStatus.PRECONDITION_FAILED.value());
        }
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.getWriter().write(JsonMapper.toJSONString((Object)res));
    }
}

