/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.featureprobe.api.auth.UserPasswordAuthenticationToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class UserPasswordAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPasswordAuthenticationProcessingFilter.class);
    private static final String GUEST_LOGIN_PATH = "/api/login";
    private static final String GUEST_LOGIN_ACCOUNT_PARAM = "account";
    private static final String ACCOUNT_SOURCE = "source";
    private static final String GUEST_LOGIN_PASSWORD_PARAM = "password";
    private static final String LOGIN_ORGANIZATION_PARAM = "organizationId";
    private static final String INITIALIZE_ORGANIZATION_PARAM = "initializeOrganization";

    protected UserPasswordAuthenticationProcessingFilter() {
        super(GUEST_LOGIN_PATH);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ServletInputStream is = request.getInputStream();
        String body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        Map authParam = (Map)mapper.readValue(body, Map.class);
        String account = (String)authParam.get(GUEST_LOGIN_ACCOUNT_PARAM);
        String source = (String)authParam.get(ACCOUNT_SOURCE);
        String password = (String)authParam.get(GUEST_LOGIN_PASSWORD_PARAM);
        String organizationId = (String)authParam.get(LOGIN_ORGANIZATION_PARAM);
        String initializeOrganizationParam = (String)authParam.get(INITIALIZE_ORGANIZATION_PARAM);
        boolean initializeOrganization = false;
        if (StringUtils.isNotBlank((CharSequence)initializeOrganizationParam)) {
            initializeOrganization = Boolean.parseBoolean(initializeOrganizationParam);
        }
        return this.getAuthenticationManager().authenticate((Authentication)new UserPasswordAuthenticationToken(account, source, password, organizationId, initializeOrganization));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
    }
}

