/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.component;

import io.featureprobe.api.base.enums.ResourceType;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class I18nConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nConverter.class);
    private MessageSource messageSource;

    public String get(String msgKey) {
        try {
            return this.messageSource.getMessage(msgKey, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            log.error("i18n language conversion failed", (Throwable)e);
            return msgKey;
        }
    }

    public String get(String msgKey, Object[] args) {
        try {
            return this.messageSource.getMessage(msgKey, args, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            log.error("i18n language conversion failed", (Throwable)e);
            return msgKey;
        }
    }

    public String getResourceNameMessage(ResourceType resourceType) {
        return this.get("resource." + resourceType.name().toLowerCase());
    }

    @Generated
    public I18nConverter(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

