/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.config;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
public class LdapConfig {
    @Value(value="${app.security.ldap.url:ldap://ldap.forumsys.com:389}")
    private String ldapUrl;
    @Value(value="${app.security.ldap.base:dc=example,dc=com}")
    public String ldapBase;
    @Value(value="${app.security.ldap.userDn:cn=read-only-admin,dc=example,dc=com}")
    private String ldapUserDn;
    @Value(value="${app.security.ldap.password:password}")
    private String ldapPassword;
    @Value(value="${app.security.ldap.connect.timeout:5000}")
    private String connectTimeout;
    @Value(value="${app.security.ldap.request.timeout:5000}")
    private int requestTimeout;
    @Value(value="${app.security.ldap.usernameAttribute:uid}")
    private String usernameAttribute;

    @Bean
    public LdapContextSource contextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapUrl);
        contextSource.setUserDn(this.ldapUserDn);
        contextSource.setPassword(this.ldapPassword);
        contextSource.setBase(this.ldapBase);
        contextSource.setBaseEnvironmentProperties(Collections.singletonMap("com.sun.jndi.ldap.connect.timeout", this.connectTimeout));
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    @Bean
    public LdapTemplate ldapTemplate() {
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)this.contextSource());
        ldapTemplate.setDefaultTimeLimit(this.requestTimeout);
        ldapTemplate.setIgnorePartialResultException(true);
        return ldapTemplate;
    }

    @Bean
    public String ldapUsernameAttribute() {
        return this.usernameAttribute;
    }
}

