/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.config;

import io.featureprobe.api.base.cache.ICache;
import io.featureprobe.api.base.cache.MemoryCache;
import io.featureprobe.api.base.component.SpringBeanManager;
import io.featureprobe.api.config.AppConfig;
import io.featureprobe.api.dao.repository.PublishMessageRepository;
import io.featureprobe.api.server.CacheServerDataSource;
import io.featureprobe.api.server.DBServerDataSource;
import io.featureprobe.api.server.ServerDataSource;
import io.featureprobe.api.service.BaseServerService;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ServerDataSourceConfig {
    private static final String SERVER_DATA_SOURCE_DB = "DB";
    private static final String SERVER_DATA_SOURCE_CACHE = "MEMORY";
    AppConfig appConfig;
    PublishMessageRepository publishMessageRepository;
    BaseServerService baseServerService;
    ApplicationEventPublisher eventPublisher;
    SpringBeanManager springBeanManager;

    @Bean
    public ServerDataSource serverDataSource() {
        String serverDataSource = this.appConfig.getServerDataSource();
        if (StringUtils.isNotBlank((CharSequence)serverDataSource) && StringUtils.equalsIgnoreCase((CharSequence)serverDataSource, (CharSequence)SERVER_DATA_SOURCE_DB)) {
            return new DBServerDataSource(this.baseServerService);
        }
        if (StringUtils.isNotBlank((CharSequence)serverDataSource) && StringUtils.equalsIgnoreCase((CharSequence)serverDataSource, (CharSequence)SERVER_DATA_SOURCE_CACHE)) {
            MemoryCache cache = MemoryCache.createArrayByteCache((long)600L);
            return new CacheServerDataSource((ICache<String, byte[]>)cache, this.publishMessageRepository, this.baseServerService, this.eventPublisher);
        }
        return new DBServerDataSource(this.baseServerService);
    }

    @Generated
    public ServerDataSourceConfig(AppConfig appConfig, PublishMessageRepository publishMessageRepository, BaseServerService baseServerService, ApplicationEventPublisher eventPublisher, SpringBeanManager springBeanManager) {
        this.appConfig = appConfig;
        this.publishMessageRepository = publishMessageRepository;
        this.baseServerService = baseServerService;
        this.eventPublisher = eventPublisher;
        this.springBeanManager = springBeanManager;
    }
}

