/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import com.google.common.collect.Maps;
import io.featureprobe.api.base.enums.LoginMode;
import io.featureprobe.api.config.JWTConfig;
import io.featureprobe.api.dto.AppSettingsResponse;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.Arrays;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/application"})
@Hidden
public class ApplicationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    private final JWTConfig jwtConfig;
    @Value(value="${app.get-started-server-url}")
    private String serverURI;

    public ApplicationController(JWTConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    @RequestMapping(value={"/settings"})
    public AppSettingsResponse getSettings() {
        AppSettingsResponse appSettingsResponse = new AppSettingsResponse();
        appSettingsResponse.setLoginMode(this.jwtConfig.isGuestDisabled() ? LoginMode.PASSWORD : LoginMode.GUEST);
        appSettingsResponse.setServerURI(this.serverURI);
        return appSettingsResponse;
    }

    public static void main(String[] args) {
        HashMap map = Maps.newHashMap();
        map.put(Arrays.asList(2, 1), new Object());
        System.out.println(map.get(Arrays.asList(2, 1.0)));
    }
}

