/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.enums.ApprovalStatusEnum;
import io.featureprobe.api.dto.ApprovalRecordQueryRequest;
import io.featureprobe.api.dto.ApprovalRecordResponse;
import io.featureprobe.api.dto.ApprovalTotalResponse;
import io.featureprobe.api.service.ApprovalRecordService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@DefaultApiResponses
@Tag(name="Approval records", description="The approval records API allows you to list and total approval records programmatically.")
@RequestMapping(value={"/api/approvalRecords"})
@RestController
public class ApprovalRecordController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApprovalRecordController.class);
    private ApprovalRecordService approvalRecordService;

    @GetMapping
    @GetApiResponse
    @Operation(summary="List approval records", description="Use filter to fetch approval records list.")
    public Page<ApprovalRecordResponse> list(@Validated ApprovalRecordQueryRequest queryRequest) {
        return this.approvalRecordService.list(queryRequest);
    }

    @GetMapping(value={"/total"})
    @GetApiResponse
    @Operation(summary="Total approval records", description="Total approval records by status.")
    public ApprovalTotalResponse total(@Schema(description="Built-in status for the approval record.") ApprovalStatusEnum status) {
        return new ApprovalTotalResponse(this.approvalRecordService.total(status));
    }

    @Generated
    public ApprovalRecordController(ApprovalRecordService approvalRecordService) {
        this.approvalRecordService = approvalRecordService;
    }
}

