/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.CreateApiResponse;
import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.EnvironmentKeyParameter;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.doc.ProjectKeyParameter;
import io.featureprobe.api.base.doc.ToggleKeyParameter;
import io.featureprobe.api.base.enums.SDKType;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.dto.AnalysisRequest;
import io.featureprobe.api.dto.AnalysisResultResponse;
import io.featureprobe.api.dto.MetricConfigResponse;
import io.featureprobe.api.dto.MetricCreateRequest;
import io.featureprobe.api.dto.MetricIterationResponse;
import io.featureprobe.api.dto.MetricResponse;
import io.featureprobe.api.dto.MetricStatusResponse;
import io.featureprobe.api.service.MetricService;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projects/{projectKey}/environments/{environmentKey}/toggles/{toggleKey}/metric"})
@DefaultApiResponses
@ProjectKeyParameter
@EnvironmentKeyParameter
@ToggleKeyParameter
@ResourceExistsValidate
@Tag(name="Metric", description="The metric API allows you to create, update and query metric programmatically.")
public class MetricController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricController.class);
    private MetricService metricService;

    @PostMapping
    @CreateApiResponse
    @Operation(summary="Create or Update metric", description="Create a new metric or Update a exists metric.")
    public MetricResponse create(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, @RequestBody @Validated MetricCreateRequest request) {
        return this.metricService.create(projectKey, environmentKey, toggleKey, request);
    }

    @GetMapping
    @GetApiResponse
    @Operation(summary="Get Metric", description="Get a single metric by toggle.")
    public MetricConfigResponse query(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey) {
        return this.metricService.query(projectKey, environmentKey, toggleKey);
    }

    @GetMapping(value={"/analysis"})
    @GetApiResponse
    @Operation(summary="Get Metric", description="Get a single metric by toggle.")
    public AnalysisResultResponse analysis(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, AnalysisRequest params) {
        return this.metricService.analysis(projectKey, environmentKey, toggleKey, params);
    }

    @GetMapping(value={"/iterations"})
    @GetApiResponse
    @Operation(summary="Get Iteration", description="Get a single metric iteration by toggle.")
    public List<MetricIterationResponse> iteration(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey) {
        return this.metricService.iteration(projectKey, environmentKey, toggleKey);
    }

    @GetApiResponse
    @GetMapping(value={"/status"})
    @Operation(summary="Get metric status", description="Get whether the specified environment toggle is report metric data.")
    public MetricStatusResponse status(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, @RequestParam(value="sdkType", required=false) SDKType sdkType) {
        return new MetricStatusResponse(this.metricService.existsEvent(projectKey, environmentKey, toggleKey, sdkType));
    }

    @GetApiResponse
    @GetMapping(value={"/diagnosis"})
    @Operation(summary="Get metric diagnosis info", description="Diagnosis of abnormal analysis results for diagnostic metric.")
    public BaseResponse diagnosis(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, AnalysisRequest params) {
        return this.metricService.diagnosis(projectKey, environmentKey, toggleKey, params);
    }

    @Generated
    public MetricController(MetricService metricService) {
        this.metricService = metricService;
    }
}

