/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.CreateApiResponse;
import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.DeleteApiResponse;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.doc.PatchApiResponse;
import io.featureprobe.api.base.doc.ProjectKeyParameter;
import io.featureprobe.api.base.enums.ResponseCodeEnum;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.base.hook.Action;
import io.featureprobe.api.base.hook.Hook;
import io.featureprobe.api.base.hook.Resource;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.dto.ApprovalSettingsResponse;
import io.featureprobe.api.dto.PreferenceCreateRequest;
import io.featureprobe.api.dto.ProjectCreateRequest;
import io.featureprobe.api.dto.ProjectQueryRequest;
import io.featureprobe.api.dto.ProjectResponse;
import io.featureprobe.api.dto.ProjectUpdateRequest;
import io.featureprobe.api.service.ProjectService;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projects"})
@DefaultApiResponses
@ProjectKeyParameter
@ResourceExistsValidate
@Tag(name="Projects", description="The projects API allows you to list, create, modify, query and delete project programmatically. <br/> You can also query and update approval settings.")
public class ProjectController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectController.class);
    private ProjectService projectService;

    @PostMapping
    @CreateApiResponse
    @Operation(summary="Create project", description="Create a new project.")
    @Hook(resource=Resource.PROJECT, action=Action.CREATE)
    public ProjectResponse create(@RequestBody @Validated ProjectCreateRequest createRequest) {
        return this.projectService.create(createRequest);
    }

    @PatchMapping(value={"/{projectKey}"})
    @PatchApiResponse
    @Operation(summary="Update project", description="Update a project.")
    @Hook(resource=Resource.PROJECT, action=Action.UPDATE)
    public ProjectResponse update(@PathVariable(value="projectKey") String projectKey, @RequestBody @Validated ProjectUpdateRequest updateRequest) {
        return this.projectService.update(projectKey, updateRequest);
    }

    @DeleteMapping(value={"/{projectKey}"})
    @DeleteApiResponse
    @Operation(summary="Delete project", description="Delete a project.")
    @Hook(resource=Resource.PROJECT, action=Action.DELETE)
    public ProjectResponse delete(@PathVariable(value="projectKey") String projectKey) {
        return this.projectService.delete(projectKey);
    }

    @GetMapping
    @GetApiResponse
    @Operation(summary="List projects", description="Fetch a list of all projects.")
    public Object list(ProjectQueryRequest queryRequest) {
        return this.projectService.list(queryRequest);
    }

    @GetMapping(value={"/{projectKey}"})
    @GetApiResponse
    @Operation(summary="Query project", description="Get a single project by key.")
    public ProjectResponse query(@PathVariable(value="projectKey") String projectKey) {
        return this.projectService.queryByKey(projectKey);
    }

    @GetMapping(value={"/exists"})
    @GetApiResponse
    @Operation(summary="Check project exist", description="Check project exist.")
    public BaseResponse exists(@RequestParam @Schema(description="The type needs to be checked.") ValidateTypeEnum type, @RequestParam @Schema(description="The attribute value to be checked.") String value) {
        this.projectService.validateExists(type, value);
        return new BaseResponse(ResponseCodeEnum.SUCCESS);
    }

    @PatchMapping(value={"/{projectKey}/approvalSettings"})
    @PatchApiResponse
    @Operation(summary="Update approval settings", description="Update approval settings for project.")
    @Hook(resource=Resource.PROJECT, action=Action.UPDATE_APPROVAL_SETTINGS)
    public List<ApprovalSettingsResponse> updateApprovalSettings(@PathVariable(value="projectKey") String projectKey, @RequestBody @Validated PreferenceCreateRequest createRequest) {
        return this.projectService.updateApprovalSettings(projectKey, createRequest);
    }

    @GetMapping(value={"/{projectKey}/approvalSettings"})
    @GetApiResponse
    @Operation(summary="Get approval settings", description="Get approval settings for project.")
    public List<ApprovalSettingsResponse> approvalSettingsList(@PathVariable(value="projectKey") String projectKey) {
        return this.projectService.approvalSettingsList(projectKey);
    }

    @Generated
    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }
}

