/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.dto.SdkKeyResponse;
import io.featureprobe.api.dto.ServerResponse;
import io.featureprobe.api.dto.TrafficCreateRequest;
import io.featureprobe.api.server.ServerDataSource;
import io.featureprobe.api.service.EnvironmentService;
import io.featureprobe.api.service.TrafficService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/server/"})
@Hidden
public class ServerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerController.class);
    private TrafficService trafficService;
    private ServerDataSource dataSource;
    private EnvironmentService environmentService;

    @GetMapping(value={"/sdk_keys"})
    public SdkKeyResponse queryAllSdkKeys(@RequestParam(value="version", required=false) Long version, HttpServletResponse response) throws Exception {
        SdkKeyResponse sdkKeyResponse = this.dataSource.queryAllSdkKeys();
        if (Objects.isNull(sdkKeyResponse)) {
            response.setStatus(404);
        } else if (Objects.nonNull(version) && version >= sdkKeyResponse.getVersion()) {
            response.setStatus(406);
            return null;
        }
        return sdkKeyResponse;
    }

    @GetMapping(value={"/toggles"})
    public ServerResponse fetchToggles(@Parameter(description="sdk key") @RequestHeader(value="Authorization") String sdkKey, @RequestParam(value="version", required=false) Long version, HttpServletResponse response) throws Exception {
        ServerResponse serverResponse = this.dataSource.queryServerTogglesByServerSdkKey(sdkKey);
        if (Objects.isNull(serverResponse)) {
            response.setStatus(404);
        } else if (Objects.nonNull(version) && version >= serverResponse.getVersion()) {
            response.setStatus(406);
            return null;
        }
        return serverResponse;
    }

    @PostMapping(value={"/events"})
    @ExcludeTenant
    public void createEvent(@RequestBody @Validated List<TrafficCreateRequest> batchRequest, @Parameter(description="sdk key") @RequestHeader(value="Authorization") String sdkKey, @RequestHeader(value="user-agent", required=false) String userAgent, @RequestHeader(value="UA", required=false) String javascriptUserAgent) {
        if (StringUtils.isNotBlank((CharSequence)javascriptUserAgent)) {
            userAgent = javascriptUserAgent;
        }
        this.trafficService.create(this.environmentService.getSdkServerKey(sdkKey), userAgent, batchRequest);
    }

    @Generated
    public ServerController(TrafficService trafficService, ServerDataSource dataSource, EnvironmentService environmentService) {
        this.trafficService = trafficService;
        this.dataSource = dataSource;
        this.environmentService = environmentService;
    }
}

