/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.CreateApiResponse;
import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.doc.PatchApiResponse;
import io.featureprobe.api.base.doc.ProjectKeyParameter;
import io.featureprobe.api.base.doc.ToggleKeyParameter;
import io.featureprobe.api.base.enums.ResponseCodeEnum;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.base.hook.Action;
import io.featureprobe.api.base.hook.Hook;
import io.featureprobe.api.base.hook.Resource;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.dto.ToggleCreateRequest;
import io.featureprobe.api.dto.ToggleItemResponse;
import io.featureprobe.api.dto.ToggleResponse;
import io.featureprobe.api.dto.ToggleSearchRequest;
import io.featureprobe.api.dto.ToggleUpdateRequest;
import io.featureprobe.api.service.IncludeArchivedToggleService;
import io.featureprobe.api.service.ToggleService;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Toggles", description="The toggles API allows you to list, create, modify, query, offline and restore toggles programmatically.")
@RequestMapping(value={"/api/projects/{projectKey}/toggles"})
@ProjectKeyParameter
@ToggleKeyParameter
@DefaultApiResponses
@ResourceExistsValidate
@RestController
public class ToggleController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToggleController.class);
    private ToggleService toggleService;
    private IncludeArchivedToggleService includeArchivedToggleService;

    @GetMapping
    @GetApiResponse
    @Operation(summary="List toggles", description="Get a list of all toggles in the project.")
    public Page<ToggleItemResponse> list(@PathVariable(name="projectKey") String projectKey, @Validated ToggleSearchRequest filter) {
        return this.toggleService.list(projectKey, filter);
    }

    @CreateApiResponse
    @PostMapping
    @Operation(summary="Create toggle", description="Create a new toggle.")
    @Hook(resource=Resource.TOGGLE, action=Action.CREATE)
    public ToggleResponse create(@PathVariable(name="projectKey") String projectKey, @RequestBody @Validated ToggleCreateRequest toggleCreateRequest) {
        this.includeArchivedToggleService.validateIncludeArchivedToggleByKey(projectKey, toggleCreateRequest.getKey());
        this.includeArchivedToggleService.validateIncludeArchivedToggleByName(projectKey, toggleCreateRequest.getName());
        return this.toggleService.create(projectKey, toggleCreateRequest);
    }

    @PatchApiResponse
    @PatchMapping(value={"/{toggleKey}"})
    @Operation(summary="Update toggle", description="Update a toggle.")
    @Hook(resource=Resource.TOGGLE, action=Action.UPDATE)
    public ToggleResponse update(@PathVariable(name="projectKey") String projectKey, @PathVariable(name="toggleKey") String toggleKey, @RequestBody @Validated ToggleUpdateRequest toggleUpdateRequest) {
        return this.toggleService.update(projectKey, toggleKey, toggleUpdateRequest);
    }

    @PatchMapping(value={"/{toggleKey}/offline"})
    @PatchApiResponse
    @Operation(summary="Offline toggle", description="Offline a toggle.")
    @Hook(resource=Resource.TOGGLE, action=Action.OFFLINE)
    public ToggleResponse offline(@PathVariable(name="projectKey") String projectKey, @PathVariable(name="toggleKey") String toggleKey) {
        return this.toggleService.offline(projectKey, toggleKey);
    }

    @PatchMapping(value={"/{toggleKey}/restore"})
    @PatchApiResponse
    @Operation(summary="Restore toggle", description="Restore a offline toggle.")
    @Hook(resource=Resource.TOGGLE, action=Action.RESTORE)
    public ToggleResponse restore(@PathVariable(name="projectKey") String projectKey, @PathVariable(name="toggleKey") String toggleKey) {
        return this.toggleService.restore(projectKey, toggleKey);
    }

    @GetApiResponse
    @GetMapping(value={"/{toggleKey}"})
    @Operation(summary="Get toggle", description="Get a single toggle by key.")
    public ToggleResponse query(@PathVariable(name="projectKey") String projectKey, @PathVariable(name="toggleKey") String toggleKey) {
        return this.toggleService.queryByKey(projectKey, toggleKey);
    }

    @GetMapping(value={"/exists"})
    @GetApiResponse
    @Operation(summary="Check toggle exist", description="Check toggle exist")
    public BaseResponse checkKey(@PathVariable(value="projectKey") String projectKey, @RequestParam @Schema(description="The type needs to be checked.") ValidateTypeEnum type, @RequestParam @Schema(description="The attribute value to be checked.") String value) {
        this.includeArchivedToggleService.validateIncludeArchivedToggle(projectKey, type, value);
        return new BaseResponse(ResponseCodeEnum.SUCCESS);
    }

    @Generated
    public ToggleController(ToggleService toggleService, IncludeArchivedToggleService includeArchivedToggleService) {
        this.toggleService = toggleService;
        this.includeArchivedToggleService = includeArchivedToggleService;
    }
}

