/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.controller;

import io.featureprobe.api.base.doc.DefaultApiResponses;
import io.featureprobe.api.base.doc.EnvironmentKeyParameter;
import io.featureprobe.api.base.doc.GetApiResponse;
import io.featureprobe.api.base.doc.ProjectKeyParameter;
import io.featureprobe.api.base.doc.ToggleKeyParameter;
import io.featureprobe.api.base.enums.SDKType;
import io.featureprobe.api.base.enums.TrafficType;
import io.featureprobe.api.dto.AccessStatusResponse;
import io.featureprobe.api.dto.TrafficResponse;
import io.featureprobe.api.service.TrafficChartService;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projects/{projectKey}/environments/{environmentKey}/toggles/{toggleKey}"})
@DefaultApiResponses
@ProjectKeyParameter
@ToggleKeyParameter
@EnvironmentKeyParameter
@ResourceExistsValidate
@Tag(name="Traffic", description="The traffic API allows you to statistics toggle access events.")
public class TrafficController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficController.class);
    private TrafficChartService trafficChartService;

    @GetApiResponse
    @GetMapping(value={"/traffic"})
    @Operation(summary="Query Traffic", description="Get the access statistics report of the toggle for a period of time.")
    public TrafficResponse query(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, @Schema(description="Metrics group type.") @RequestParam(value="trafficType", defaultValue="VALUE") TrafficType trafficType, @Schema(description="Metrics statistical time granularity.") @RequestParam(value="lastHours", defaultValue="24") int lastHours) {
        return this.trafficChartService.query(projectKey, environmentKey, toggleKey, trafficType, lastHours);
    }

    @GetApiResponse
    @GetMapping(value={"/access"})
    @Operation(summary="Get access status", description="Get whether the specified environment toggle is accessed.")
    public AccessStatusResponse query(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="environmentKey") String environmentKey, @PathVariable(value="toggleKey") String toggleKey, @RequestParam(value="sdkType", required=false) SDKType sdkType) {
        return new AccessStatusResponse(this.trafficChartService.isAccess(projectKey, environmentKey, toggleKey, sdkType));
    }

    @Generated
    public TrafficController(TrafficChartService trafficChartService) {
        this.trafficChartService = trafficChartService;
    }
}

