/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dto;

import io.featureprobe.api.base.enums.AlgorithmDenominatorEnum;
import io.featureprobe.api.base.enums.EventTypeEnum;
import io.featureprobe.api.base.enums.MatcherTypeEnum;
import io.featureprobe.api.base.enums.MetricTypeEnum;
import io.featureprobe.api.base.enums.WinCriteria;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class MetricCreateRequest {
    @Schema(description="The name of the metric.")
    @NotBlank
    private String name;
    @Schema(description="The description of the metric.")
    private String description;
    @Schema(description="The type of the metric.")
    @NotNull
    private MetricTypeEnum metricType;
    @Schema(description="The type of the event.")
    @NotNull
    private EventTypeEnum eventType;
    @Schema(description="The denominator of the metric.")
    @NotNull
    private AlgorithmDenominatorEnum denominator;
    @Schema(description="The unit of the NUMERIC metric.")
    private String unit;
    @Schema(description="The win criteria of the NUMERIC metric.")
    private WinCriteria winCriteria;
    @Schema(description="The name of the event. Use the event name in the code buried point. <br/> Only contain letters, numbers, '.', '_' Or '-', and the length is greater than 4.")
    private String eventName;
    @Schema(description="The URL matching pattern.")
    private MatcherTypeEnum matcher = null;
    @Schema(description="The url of the event.")
    private String url;
    @Schema(description="The css selector of the event.")
    private String selector;

    @Generated
    public MetricCreateRequest() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    @Generated
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    @Generated
    public AlgorithmDenominatorEnum getDenominator() {
        return this.denominator;
    }

    @Generated
    public String getUnit() {
        return this.unit;
    }

    @Generated
    public WinCriteria getWinCriteria() {
        return this.winCriteria;
    }

    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @Generated
    public MatcherTypeEnum getMatcher() {
        return this.matcher;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSelector() {
        return this.selector;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setMetricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    @Generated
    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setDenominator(AlgorithmDenominatorEnum denominator) {
        this.denominator = denominator;
    }

    @Generated
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Generated
    public void setWinCriteria(WinCriteria winCriteria) {
        this.winCriteria = winCriteria;
    }

    @Generated
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Generated
    public void setMatcher(MatcherTypeEnum matcher) {
        this.matcher = matcher;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSelector(String selector) {
        this.selector = selector;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricCreateRequest)) {
            return false;
        }
        MetricCreateRequest other = (MetricCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MetricTypeEnum this$metricType = this.getMetricType();
        MetricTypeEnum other$metricType = other.getMetricType();
        if (this$metricType == null ? other$metricType != null : !this$metricType.equals(other$metricType)) {
            return false;
        }
        EventTypeEnum this$eventType = this.getEventType();
        EventTypeEnum other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        AlgorithmDenominatorEnum this$denominator = this.getDenominator();
        AlgorithmDenominatorEnum other$denominator = other.getDenominator();
        if (this$denominator == null ? other$denominator != null : !this$denominator.equals(other$denominator)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        WinCriteria this$winCriteria = this.getWinCriteria();
        WinCriteria other$winCriteria = other.getWinCriteria();
        if (this$winCriteria == null ? other$winCriteria != null : !this$winCriteria.equals(other$winCriteria)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        MatcherTypeEnum this$matcher = this.getMatcher();
        MatcherTypeEnum other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$selector = this.getSelector();
        String other$selector = other.getSelector();
        return !(this$selector == null ? other$selector != null : !this$selector.equals(other$selector));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MetricTypeEnum $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : $metricType.hashCode());
        EventTypeEnum $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        AlgorithmDenominatorEnum $denominator = this.getDenominator();
        result = result * 59 + ($denominator == null ? 43 : $denominator.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        WinCriteria $winCriteria = this.getWinCriteria();
        result = result * 59 + ($winCriteria == null ? 43 : $winCriteria.hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        MatcherTypeEnum $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricCreateRequest(name=" + this.getName() + ", description=" + this.getDescription() + ", metricType=" + this.getMetricType() + ", eventType=" + this.getEventType() + ", denominator=" + this.getDenominator() + ", unit=" + this.getUnit() + ", winCriteria=" + this.getWinCriteria() + ", eventName=" + this.getEventName() + ", matcher=" + this.getMatcher() + ", url=" + this.getUrl() + ", selector=" + this.getSelector() + ")";
    }
}

