/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.featureprobe.api.base.model.TargetingContent;
import io.featureprobe.api.dto.ToggleControlConfRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class TargetingPublishRequest
extends ToggleControlConfRequest {
    private TargetingContent content;
    @Schema(description="Release notes")
    private String comment;
    @Schema(description="Disables the toggle.")
    private Boolean disabled;
    @Schema(description="The current updated version.")
    private Long baseVersion;

    public TargetingPublishRequest(TargetingContent content, String comment, Boolean disabled, ToggleControlConfRequest toggleControlConfRequest) {
        this.content = content;
        this.comment = comment;
        this.disabled = disabled;
        if (toggleControlConfRequest != null) {
            this.setTrackAccessEvents(toggleControlConfRequest.getTrackAccessEvents());
        }
    }

    @JsonIgnore
    public Boolean isUpdateTargetingRules() {
        return this.disabled != null || this.content != null;
    }

    @Generated
    public TargetingContent getContent() {
        return this.content;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Boolean getDisabled() {
        return this.disabled;
    }

    @Generated
    public Long getBaseVersion() {
        return this.baseVersion;
    }

    @Generated
    public void setContent(TargetingContent content) {
        this.content = content;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setBaseVersion(Long baseVersion) {
        this.baseVersion = baseVersion;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetingPublishRequest)) {
            return false;
        }
        TargetingPublishRequest other = (TargetingPublishRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disabled = this.getDisabled();
        Boolean other$disabled = other.getDisabled();
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Long this$baseVersion = this.getBaseVersion();
        Long other$baseVersion = other.getBaseVersion();
        if (this$baseVersion == null ? other$baseVersion != null : !((Object)this$baseVersion).equals(other$baseVersion)) {
            return false;
        }
        TargetingContent this$content = this.getContent();
        TargetingContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TargetingPublishRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disabled = this.getDisabled();
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Long $baseVersion = this.getBaseVersion();
        result = result * 59 + ($baseVersion == null ? 43 : ((Object)$baseVersion).hashCode());
        TargetingContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TargetingPublishRequest(content=" + this.getContent() + ", comment=" + this.getComment() + ", disabled=" + this.getDisabled() + ", baseVersion=" + this.getBaseVersion() + ")";
    }

    @Generated
    public TargetingPublishRequest() {
    }
}

