/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.dto;

import io.featureprobe.api.base.model.Variation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ToggleCreateRequest {
    @Schema(description="A human-friendly name for the new toggle.")
    @NotBlank
    private String name;
    @Schema(description="A project-unique key for the new toggle.")
    @NotBlank
    private String key;
    @Schema(description="A custom description for the new toggle.")
    private String desc;
    @Schema(description="Put some tag for the new toggle.")
    private List<String> tags;
    @Schema(description="Whether to use in the client-side SDK.")
    @NotNull
    private Boolean clientAvailability;
    @Schema(description="Return types decide the toggle's return type in you code.", allowableValues={"boolean", "number", "string", "json"})
    @NotBlank
    private String returnType;
    @Schema(description="Variations decide the toggles return value in yue code.")
    @NotEmpty
    private List<Variation> variations;
    @Schema(description="Define the return value when toggle is disabled.")
    @NotNull
    private Integer disabledServe;
    @Schema(description="Whether the toggle is permanent.", defaultValue="false")
    private boolean permanent;

    @Generated
    public ToggleCreateRequest() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public Boolean getClientAvailability() {
        return this.clientAvailability;
    }

    @Generated
    public String getReturnType() {
        return this.returnType;
    }

    @Generated
    public List<Variation> getVariations() {
        return this.variations;
    }

    @Generated
    public Integer getDisabledServe() {
        return this.disabledServe;
    }

    @Generated
    public boolean isPermanent() {
        return this.permanent;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setClientAvailability(Boolean clientAvailability) {
        this.clientAvailability = clientAvailability;
    }

    @Generated
    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Generated
    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    @Generated
    public void setDisabledServe(Integer disabledServe) {
        this.disabledServe = disabledServe;
    }

    @Generated
    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToggleCreateRequest)) {
            return false;
        }
        ToggleCreateRequest other = (ToggleCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPermanent() != other.isPermanent()) {
            return false;
        }
        Boolean this$clientAvailability = this.getClientAvailability();
        Boolean other$clientAvailability = other.getClientAvailability();
        if (this$clientAvailability == null ? other$clientAvailability != null : !((Object)this$clientAvailability).equals(other$clientAvailability)) {
            return false;
        }
        Integer this$disabledServe = this.getDisabledServe();
        Integer other$disabledServe = other.getDisabledServe();
        if (this$disabledServe == null ? other$disabledServe != null : !((Object)this$disabledServe).equals(other$disabledServe)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$returnType = this.getReturnType();
        String other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
            return false;
        }
        List<Variation> this$variations = this.getVariations();
        List<Variation> other$variations = other.getVariations();
        return !(this$variations == null ? other$variations != null : !((Object)this$variations).equals(other$variations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ToggleCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPermanent() ? 79 : 97);
        Boolean $clientAvailability = this.getClientAvailability();
        result = result * 59 + ($clientAvailability == null ? 43 : ((Object)$clientAvailability).hashCode());
        Integer $disabledServe = this.getDisabledServe();
        result = result * 59 + ($disabledServe == null ? 43 : ((Object)$disabledServe).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        List<Variation> $variations = this.getVariations();
        result = result * 59 + ($variations == null ? 43 : ((Object)$variations).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ToggleCreateRequest(name=" + this.getName() + ", key=" + this.getKey() + ", desc=" + this.getDesc() + ", tags=" + this.getTags() + ", clientAvailability=" + this.getClientAvailability() + ", returnType=" + this.getReturnType() + ", variations=" + this.getVariations() + ", disabledServe=" + this.getDisabledServe() + ", permanent=" + this.isPermanent() + ")";
    }
}

