/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
@Order(value=1)
public class UiFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UiFilter.class);
    private final String passUri = "/static/css/**;/static/js/**;/static/media/**;/api/**;/internal/**;/favicon.ico;/asset-manifest.json;/actuator/health;";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!this.pass(request.getRequestURI())) {
            servletRequest.getRequestDispatcher("/index.html").forward(servletRequest, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean pass(String uri) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : "/static/css/**;/static/js/**;/static/media/**;/api/**;/internal/**;/favicon.ico;/asset-manifest.json;/actuator/health;".split(";")) {
            if (!matcher.match(pattern, uri)) continue;
            return true;
        }
        return false;
    }
}

