/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.hook;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.featureprobe.api.base.exception.SignatureException;
import io.featureprobe.api.base.hook.ICallback;
import io.featureprobe.api.base.model.CallbackResult;
import io.featureprobe.api.base.model.HookContext;
import io.featureprobe.api.mapper.HookContextMapper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="COMMON")
public class CommonCallback
implements ICallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonCallback.class);
    private static final String USER_AGENT_KEY = "User-Agent";
    private static final String USER_AGENT_VALUE = "FeatureProbe-Webhook/1.0";
    private static final String SIGN_KEY = "X-FeatureProbe-Sign";
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(Duration.ofSeconds(3L)).readTimeout(Duration.ofSeconds(3L)).writeTimeout(Duration.ofSeconds(3L)).retryOnConnectionFailure(true).build();
    private final ObjectMapper mapper = new ObjectMapper();

    public CallbackResult callback(HookContext hookContext, String url, String secretKey) {
        CallbackResult result = new CallbackResult();
        try {
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String requestBodyStr = this.mapper.writeValueAsString((Object)HookContextMapper.INSTANCE.contextToRequestBody(hookContext));
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestBodyStr);
            Request request = new Request.Builder().header(USER_AGENT_KEY, USER_AGENT_VALUE).header(SIGN_KEY, this.sign(secretKey, requestBodyStr)).url(url).post(requestBody).build();
            Response response = this.httpClient.newCall(request).execute();
            log.debug("Common Callback response\uff1a {}", (Object)response);
            result.setSuccess(response.isSuccessful());
            result.setRequestBody(requestBodyStr);
            result.setStatusCode(response.code());
            result.setResponseBody(response.body().string());
        }
        catch (Exception e) {
            log.error("Common Callback error", (Throwable)e);
            result.setSuccess(false);
            result.setErrorMessage(e.getMessage());
            result.setTime(new Date());
            return result;
        }
        result.setTime(new Date());
        return result;
    }

    private String sign(String secretKey, String content) {
        try {
            SecretKeySpec signinKey = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signinKey);
            byte[] rawHmac = mac.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            log.error("WebHook Callback failed sign for key:{} and content:{}", new Object[]{secretKey, content, e});
            throw new SignatureException(e.getMessage());
        }
    }
}

