/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dto.ApprovalSettings;
import io.featureprobe.api.dto.ApprovalSettingsResponse;
import io.featureprobe.api.dto.EnvironmentCreateRequest;
import io.featureprobe.api.dto.EnvironmentResponse;
import io.featureprobe.api.dto.EnvironmentUpdateRequest;
import java.util.List;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

@Mapper
public interface EnvironmentMapper {
    public static final EnvironmentMapper INSTANCE = (EnvironmentMapper)Mappers.getMapper(EnvironmentMapper.class);

    public EnvironmentResponse entityToResponse(Environment var1);

    public Environment requestToEntity(EnvironmentCreateRequest var1);

    @Mappings(value={@Mapping(target="environmentKey", source="key"), @Mapping(target="environmentName", source="name"), @Mapping(target="enable", source="enableApproval"), @Mapping(target="reviewers", expression="java(toReviewerList(environment.getReviewers()))")})
    public ApprovalSettingsResponse entityToApprovalSettingsResponse(Environment var1);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    public void mapEntity(EnvironmentUpdateRequest var1, @MappingTarget Environment var2);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    @Mappings(value={@Mapping(target="enableApproval", source="enable"), @Mapping(target="reviewers", expression="java(toReviewers(approvalSettings.getReviewers()))")})
    public void mapEntity(ApprovalSettings var1, @MappingTarget Environment var2);

    default public List<String> toReviewerList(String reviewers) {
        return JsonMapper.toListObject((String)reviewers, String.class);
    }

    default public String toReviewers(List<String> reviewers) {
        return JsonMapper.toJSONString(reviewers);
    }
}

