/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dto.MemberItemResponse;
import io.featureprobe.api.dto.MemberResponse;
import io.featureprobe.api.dto.MemberUpdateRequest;
import io.featureprobe.api.mapper.BaseMapper;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Mapper
public interface MemberMapper
extends BaseMapper {
    public static final MemberMapper INSTANCE = (MemberMapper)Mappers.getMapper(MemberMapper.class);

    @Mappings(value={@Mapping(target="account", expression="java(member.getAccount())"), @Mapping(target="nickname", expression="java(member.getNickname())"), @Mapping(target="createdBy", expression="java(getAccount(member.getCreatedBy()))"), @Mapping(target="visitedTime", expression="java(member.getVisitedTime())")})
    public MemberItemResponse entityToItemResponse(Member var1);

    @Mappings(value={@Mapping(target="account", expression="java(member.getAccount())"), @Mapping(target="createdBy", expression="java(getAccount(member.getCreatedBy()))"), @Mapping(target="modifiedBy", expression="java(getAccount(member.getModifiedBy()))")})
    public MemberResponse entityToResponse(Member var1);

    @Mappings(value={@Mapping(target="password", expression="java(toPasswordEncrypt(updateRequest.getPassword(), member))"), @Mapping(target="account", expression="java(updateRequest.getAccount())")})
    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    public void mapEntity(MemberUpdateRequest var1, @MappingTarget Member var2);

    default public String toPasswordEncrypt(String password, Member member) {
        if (StringUtils.isNotBlank((CharSequence)password)) {
            return new BCryptPasswordEncoder().encode((CharSequence)password);
        }
        return member.getPassword();
    }
}

