/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.mapper;

import io.featureprobe.api.base.model.SegmentRuleModel;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.Segment;
import io.featureprobe.api.dao.entity.Toggle;
import io.featureprobe.api.dto.SegmentCreateRequest;
import io.featureprobe.api.dto.SegmentPublishRequest;
import io.featureprobe.api.dto.SegmentResponse;
import io.featureprobe.api.dto.SegmentUpdateRequest;
import io.featureprobe.api.dto.ToggleSegmentResponse;
import io.featureprobe.api.mapper.BaseMapper;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;
import org.springframework.util.CollectionUtils;

@Mapper
public interface SegmentMapper
extends BaseMapper {
    public static final SegmentMapper INSTANCE = (SegmentMapper)Mappers.getMapper(SegmentMapper.class);

    public Segment requestToEntity(SegmentCreateRequest var1);

    @Mappings(value={@Mapping(target="rules", expression="java(toSegmentRules(segment.getRules()))"), @Mapping(target="modifiedBy", expression="java(getAccount(segment.getModifiedBy()))")})
    public SegmentResponse entityToResponse(Segment var1);

    public ToggleSegmentResponse toggleToToggleSegment(Toggle var1);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    public void mapEntity(SegmentUpdateRequest var1, @MappingTarget Segment var2);

    @Mapping(target="rules", expression="java(toSegmentRulesString(publishRequest.getRules()))")
    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
    public void mapEntity(SegmentPublishRequest var1, @MappingTarget Segment var2);

    default public String toSegmentRulesString(List<SegmentRuleModel> rules) {
        if (!CollectionUtils.isEmpty(rules)) {
            return JsonMapper.toJSONString(rules);
        }
        return this.toDefaultSegmentRulesString();
    }

    default public List<SegmentRuleModel> toSegmentRules(String rules) {
        if (StringUtils.isNotBlank((CharSequence)rules)) {
            return (List)JsonMapper.toObject((String)rules, List.class);
        }
        return this.toDefaultSegmentRules();
    }

    default public String toDefaultSegmentRulesString() {
        return JsonMapper.toJSONString(Collections.emptyList());
    }

    default public List<SegmentRuleModel> toDefaultSegmentRules() {
        return Collections.emptyList();
    }
}

