/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.config.AppConfig;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AnalysisServerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalysisServerService.class);
    AppConfig appConfig;
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(Duration.ofSeconds(3L)).readTimeout(Duration.ofSeconds(3L)).writeTimeout(Duration.ofSeconds(3L)).retryOnConnectionFailure(true).build();

    public String callAnalysisServer(String path, String query, String sdkKey) {
        String res = "{}";
        try {
            String url = this.appConfig.getAnalysisBaseUrl() + path + "?" + query;
            Request request = new Request.Builder().header("Authorization", sdkKey).url(url).get().build();
            Response response = this.httpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                res = response.body().string();
            }
            log.info("Request analysis server, url: {}, sdkKey: {}, response: {}", new Object[]{url, sdkKey, response});
        }
        catch (IOException e) {
            log.error("Call Analysis Server Error: {}", (Throwable)e);
            throw new RuntimeException(e);
        }
        return res;
    }

    public String formatHttpQuery(Map<String, Object> paramMap) {
        String param = "";
        for (String key : paramMap.keySet()) {
            if (!Objects.nonNull(paramMap.get(key))) continue;
            param = param + key + "=" + paramMap.get(key) + "&";
        }
        return param;
    }

    @Generated
    public AnalysisServerService(AppConfig appConfig) {
        this.appConfig = appConfig;
    }
}

