/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.dao.entity.Dictionary;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.DictionaryRepository;
import io.featureprobe.api.dto.DictionaryResponse;
import io.featureprobe.api.mapper.DictionaryMapper;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DictionaryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryService.class);
    private DictionaryRepository dictionaryRepository;

    public DictionaryResponse create(String key, String value) {
        String accountHash = DigestUtils.md5Hex((String)TokenHelper.getAccount());
        Optional dictionaryOptional = this.dictionaryRepository.findByAccountAndKey(accountHash, key);
        if (dictionaryOptional.isPresent()) {
            Dictionary dictionary = (Dictionary)dictionaryOptional.get();
            dictionary.setValue(value);
            dictionary.setAccount(accountHash);
            return DictionaryMapper.INSTANCE.entityToResponse((Dictionary)this.dictionaryRepository.save((Object)dictionary));
        }
        Dictionary dictionary = new Dictionary();
        dictionary.setKey(key);
        dictionary.setValue(value);
        dictionary.setAccount(accountHash);
        return DictionaryMapper.INSTANCE.entityToResponse((Dictionary)this.dictionaryRepository.save((Object)dictionary));
    }

    public DictionaryResponse query(String key) {
        String accountHash = DigestUtils.md5Hex((String)TokenHelper.getAccount());
        Dictionary dictionary = (Dictionary)this.dictionaryRepository.findByAccountAndKey(accountHash, key).orElseThrow(() -> new ResourceNotFoundException(ResourceType.DICTIONARY, key));
        return DictionaryMapper.INSTANCE.entityToResponse(dictionary);
    }

    @Generated
    public DictionaryService(DictionaryRepository dictionaryRepository) {
        this.dictionaryRepository = dictionaryRepository;
    }
}

