/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.ResponseCodeEnum;
import io.featureprobe.api.base.model.BaseResponse;
import io.featureprobe.api.base.util.JsonMapper;
import io.featureprobe.api.dao.entity.DebugEvent;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.EventTracker;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.DebugEventRepository;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.EventTrackerRepository;
import io.featureprobe.api.dao.repository.TrafficRepository;
import io.featureprobe.api.dto.EventStreamResponse;
import io.featureprobe.api.dto.EventTrackerStatusRequest;
import io.featureprobe.api.dto.SummaryEvent;
import io.featureprobe.api.mapper.EventMapper;
import io.featureprobe.api.service.AnalysisServerService;
import io.featureprobe.api.service.ChangeLogService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventTrackerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventTrackerService.class);
    EnvironmentRepository environmentRepository;
    EventTrackerRepository eventTrackerRepository;
    AnalysisServerService analysisServerService;
    DebugEventRepository debugEventRepository;
    TrafficRepository trafficRepository;
    private ChangeLogService changeLogService;
    @PersistenceContext
    public EntityManager entityManager;
    final ObjectMapper mapper = new ObjectMapper();

    @Transactional(rollbackFor={Exception.class})
    public EventStreamResponse getEventStream(String projectKey, String environmentKey, String uuid) {
        EventStreamResponse response = new EventStreamResponse();
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, projectKey + "/" + environmentKey));
        response.setProjectKey(projectKey);
        response.setEnvironmentKey(environmentKey);
        response.setDebugUntilTime(environment.getDebuggerUntilTime());
        if (environment.getDebuggerUntilTime() <= System.currentTimeMillis()) {
            return response;
        }
        response.setDebuggerEnabled(true);
        Optional eventTrackerOptional = this.eventTrackerRepository.findByProjectKeyAndEnvironmentKeyAndUuid(projectKey, environmentKey, uuid);
        if (eventTrackerOptional.isPresent()) {
            List<Object> events = new ArrayList<Object>();
            EventTracker eventTracker = (EventTracker)eventTrackerOptional.get();
            List debugEvents = this.debugEventRepository.findAllBySdkKeyAndTimeGreaterThanEqual(environment.getServerSdkKey(), eventTracker.getTime()).stream().map(debugEvent -> EventMapper.INSTANCE.debugEventToResponse((DebugEvent)debugEvent)).collect(Collectors.toList());
            List traffic = this.trafficRepository.findAllBySdkKeyAndStartDateGreaterThanEqual(environment.getServerSdkKey(), new Date(eventTracker.getTime()));
            List summaryEvents = traffic.stream().map(SummaryEvent::create).collect(Collectors.toList());
            events.addAll(debugEvents);
            events.addAll(summaryEvents);
            try {
                List<Object> accessEvents = this.callAnalysis(eventTracker.getTime(), environment.getServerSdkKey());
                events.addAll(accessEvents);
            }
            catch (Exception e) {
                log.error("Get access event stream is error.", (Throwable)e);
            }
            if (CollectionUtils.isNotEmpty(events)) {
                events = events.stream().sorted((a, b) -> this.compareEvent(a, b)).collect(Collectors.toList());
                this.updateEventTrackerTime(eventTracker, System.currentTimeMillis());
            }
            response.setEvents(events);
            return response;
        }
        this.saveEventTracker(projectKey, environmentKey, uuid);
        return response;
    }

    private int compareEvent(Object first, Object second) {
        Map firstEvent = (Map)this.mapper.convertValue(first, Map.class);
        Long firstTime = (Long)firstEvent.get("time");
        if (first instanceof SummaryEvent) {
            firstTime = ((SummaryEvent)first).getStartDate().getTime();
        }
        Map secondEvent = (Map)this.mapper.convertValue(second, Map.class);
        Long secondTime = (Long)secondEvent.get("time");
        if (second instanceof SummaryEvent) {
            secondTime = ((SummaryEvent)second).getStartDate().getTime();
        }
        return Long.compare(firstTime, secondTime);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse status(String projectKey, String environmentKey, EventTrackerStatusRequest statusRequest) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ENVIRONMENT, projectKey + "/" + environmentKey));
        if (statusRequest.isEnabled()) {
            environment.setDebuggerUntilTime(Long.valueOf(System.currentTimeMillis() + 1800000L));
        } else {
            environment.setDebuggerUntilTime(Long.valueOf(0L));
        }
        this.environmentRepository.save((Object)environment);
        this.changeLogService.create(environment, ChangeLogType.CHANGE);
        return new BaseResponse(ResponseCodeEnum.SUCCESS);
    }

    private void saveEventTracker(String projectKey, String environmentKey, String uuid) {
        EventTracker eventTracker = new EventTracker();
        eventTracker.setProjectKey(projectKey);
        eventTracker.setEnvironmentKey(environmentKey);
        eventTracker.setUuid(uuid);
        eventTracker.setTime(Long.valueOf(System.currentTimeMillis()));
        this.eventTrackerRepository.save((Object)eventTracker);
    }

    private void updateEventTrackerTime(EventTracker eventTracker, long time) {
        eventTracker.setTime(Long.valueOf(time));
        this.eventTrackerRepository.save((Object)eventTracker);
    }

    private List<Object> callAnalysis(Long time, String sdkKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", time);
        String callRes = this.analysisServerService.callAnalysisServer("/events", this.analysisServerService.formatHttpQuery(params), sdkKey);
        List events = JsonMapper.toListObject((String)callRes, Object.class);
        return events;
    }

    @Generated
    public EventTrackerService(EnvironmentRepository environmentRepository, EventTrackerRepository eventTrackerRepository, AnalysisServerService analysisServerService, DebugEventRepository debugEventRepository, TrafficRepository trafficRepository, ChangeLogService changeLogService, EntityManager entityManager) {
        this.environmentRepository = environmentRepository;
        this.eventTrackerRepository = eventTrackerRepository;
        this.analysisServerService = analysisServerService;
        this.debugEventRepository = debugEventRepository;
        this.trafficRepository = trafficRepository;
        this.changeLogService = changeLogService;
        this.entityManager = entityManager;
    }
}

