/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.config.JWTConfig;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.repository.OrganizationRepository;
import io.featureprobe.api.dto.ProjectCreateRequest;
import io.featureprobe.api.service.MemberService;
import io.featureprobe.api.service.ProjectService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ExcludeTenant
public class GuestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuestService.class);
    JWTConfig JWTConfig;
    private MemberService memberService;
    private OrganizationRepository organizationRepository;
    @PersistenceContext
    public EntityManager entityManager;
    private ProjectService projectService;
    private static final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private static final String GUEST_INIT_PROJECT_KEY = "My_Project";
    private static final String DEMO_INIT_DATA_FILE_PATH = "db/demo_init_data.sql";

    @Transactional(rollbackFor={Exception.class})
    public Member initGuest(String account, String source) {
        Organization organization = (Organization)this.organizationRepository.save((Object)new Organization(account));
        Member guestMember = this.createGuestMember(account, source, organization);
        this.loginGuestUser(guestMember);
        this.initProjectEnvironment(String.valueOf(organization.getId()), GUEST_INIT_PROJECT_KEY);
        this.initToggles(organization.getId(), guestMember.getId());
        return guestMember;
    }

    private Member createGuestMember(String account, String source, Organization organization) {
        Member member = new Member();
        member.setAccount(account);
        member.setPassword(passwordEncoder.encode((CharSequence)this.JWTConfig.getGuestDefaultPassword()));
        member.setSource(source);
        member.addOrganization(organization, OrganizationRoleEnum.OWNER);
        return this.memberService.save(member);
    }

    private void loginGuestUser(Member member) {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl((Authentication)new JwtAuthenticationToken(Jwt.withTokenValue((String)"_").claim("userId", (Object)member.getId()).claim("account", (Object)member.getAccount()).claim("role", (Object)((OrganizationMember)member.getOrganizationMembers().get(0)).getRole()).header("iss", (Object)"").build())));
    }

    private void initProjectEnvironment(String tenantId, String projectName) {
        TenantContext.setCurrentTenant((String)tenantId);
        this.projectService.create(new ProjectCreateRequest(projectName, projectName, ""));
    }

    private void initToggles(Long tenantId, Long userId) {
        try {
            String sql;
            ClassPathResource classPathResource = new ClassPathResource(DEMO_INIT_DATA_FILE_PATH);
            BufferedReader br = new BufferedReader(new InputStreamReader(classPathResource.getInputStream()));
            while (StringUtils.isNotBlank((CharSequence)(sql = br.readLine()))) {
                sql = sql.replace("${organization_id}", String.valueOf(tenantId)).replace("${project_key}", GUEST_INIT_PROJECT_KEY).replace("${user_id}", String.valueOf(userId));
                this.executeSQL(sql);
            }
        }
        catch (IOException e) {
            log.error("Demo init toggles error.", (Throwable)e);
        }
    }

    private void executeSQL(String sql) {
        Query query = this.entityManager.createNativeQuery(sql);
        query.executeUpdate();
    }

    @Generated
    public GuestService(JWTConfig JWTConfig2, MemberService memberService, OrganizationRepository organizationRepository, EntityManager entityManager, ProjectService projectService) {
        this.JWTConfig = JWTConfig2;
        this.memberService = memberService;
        this.organizationRepository = organizationRepository;
        this.entityManager = entityManager;
        this.projectService = projectService;
    }
}

