/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class IncludeArchivedEnvironmentService {
    private EnvironmentRepository environmentRepository;
    @PersistenceContext
    public EntityManager entityManager;

    @Archived
    public void validateIncludeArchivedEnvironment(String projectKey, ValidateTypeEnum type, String value) {
        switch (type) {
            case KEY: {
                this.validateIncludeArchivedEnvironmentByKey(projectKey, value);
                break;
            }
            case NAME: {
                this.validateIncludeArchivedEnvironmentByName(projectKey, value);
                break;
            }
        }
    }

    @Archived
    public void validateIncludeArchivedEnvironmentByName(String projectKey, String name) {
        if (this.environmentRepository.existsByProjectKeyAndName(projectKey, name)) {
            throw new ResourceConflictException(ResourceType.ENVIRONMENT);
        }
    }

    @Archived
    public void validateIncludeArchivedEnvironmentByKey(String projectKey, String key) {
        if (this.environmentRepository.existsByProjectKeyAndKey(projectKey, key)) {
            throw new ResourceConflictException(ResourceType.ENVIRONMENT);
        }
    }

    @Generated
    public IncludeArchivedEnvironmentService(EnvironmentRepository environmentRepository, EntityManager entityManager) {
        this.environmentRepository = environmentRepository;
        this.entityManager = entityManager;
    }
}

