/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.component.SpringBeanManager;
import io.featureprobe.api.base.db.ExcludeTenant;
import io.featureprobe.api.base.enums.MemberSourceEnum;
import io.featureprobe.api.base.enums.MemberStatusEnum;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.exception.ForbiddenException;
import io.featureprobe.api.base.model.PaginationRequest;
import io.featureprobe.api.base.security.IEncryptionService;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.dao.entity.AbstractAuditEntity;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.MemberRepository;
import io.featureprobe.api.dao.repository.OrganizationMemberRepository;
import io.featureprobe.api.dao.repository.OrganizationRepository;
import io.featureprobe.api.dao.utils.PageRequestUtil;
import io.featureprobe.api.dto.MemberCreateRequest;
import io.featureprobe.api.dto.MemberItemResponse;
import io.featureprobe.api.dto.MemberModifyPasswordRequest;
import io.featureprobe.api.dto.MemberResponse;
import io.featureprobe.api.dto.MemberSearchRequest;
import io.featureprobe.api.dto.MemberUpdateRequest;
import io.featureprobe.api.mapper.MemberMapper;
import io.featureprobe.api.service.MemberIncludeDeletedService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ExcludeTenant
@Service
public class MemberService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberService.class);
    private final MemberRepository memberRepository;
    private final MemberIncludeDeletedService memberIncludeDeletedService;
    private final OrganizationRepository organizationRepository;
    private final OrganizationMemberRepository organizationMemberRepository;
    @PersistenceContext
    public final EntityManager entityManager;
    private static final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    @Value(value="${app.security.encryption.impl:plaintext}")
    private String encryptionName;

    @Transactional(rollbackFor={Exception.class})
    public List<MemberResponse> createUserInCurrentOrganization(MemberCreateRequest createRequest) {
        return this.create(TenantContext.getCurrentOrganization().getOrganizationId(), createRequest, MemberStatusEnum.ACTIVE);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<MemberResponse> create(Long organizationId, MemberCreateRequest createRequest, MemberStatusEnum memberStatusEnum) {
        List savedMembers = this.memberRepository.saveAll(this.newMembers(organizationId, createRequest, memberStatusEnum));
        return savedMembers.stream().map(item -> this.translateResponse((Member)item)).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public MemberResponse update(MemberUpdateRequest updateRequest) {
        Member member = this.findMemberByAccount(updateRequest.getAccount());
        MemberMapper.INSTANCE.mapEntity(updateRequest, member);
        if (StringUtils.isNotBlank((CharSequence)updateRequest.getPassword()) || Objects.nonNull(updateRequest.getRole())) {
            this.verifyAdminPrivileges();
            OrganizationMember organizationMember = member.getOrganizationMembers().stream().filter(it -> it.getOrganization().getId().equals(TenantContext.getCurrentOrganization().getOrganizationId())).findFirst().orElseThrow(() -> new ResourceNotFoundException(ResourceType.ORGANIZATION_MEMBER, member.getAccount()));
            organizationMember.setRole(updateRequest.getRole());
        }
        return this.translateResponse(this.save(member));
    }

    @Transactional(rollbackFor={Exception.class})
    public MemberItemResponse modifyPassword(MemberModifyPasswordRequest modifyPasswordRequest) {
        Member member = this.findLoggedInMember();
        this.verifyPassword(modifyPasswordRequest.getOldPassword(), member.getPassword());
        member.setPassword(passwordEncoder.encode((CharSequence)modifyPasswordRequest.getNewPassword()));
        return MemberMapper.INSTANCE.entityToItemResponse(this.save(member));
    }

    @Transactional(rollbackFor={Exception.class})
    public MemberItemResponse modifyPasswordAndActive(Member member, String password) {
        if (member == null || StringUtils.isEmpty((CharSequence)password)) {
            throw new IllegalArgumentException("member or password invalid");
        }
        member.setPassword(passwordEncoder.encode((CharSequence)password));
        member.setStatus(MemberStatusEnum.ACTIVE);
        return MemberMapper.INSTANCE.entityToItemResponse(this.save(member));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateVisitedTime(String account) {
        Member member = this.findMemberByAccount(account);
        member.setVisitedTime(new Date());
        this.save(member);
    }

    @Transactional(rollbackFor={Exception.class})
    public MemberResponse delete(String account) {
        this.verifyAdminPrivileges();
        Member member = this.findMemberByAccount(account);
        member.setDeleted(Boolean.valueOf(true));
        member.deleteOrganization(Long.valueOf(Long.parseLong(TenantContext.getCurrentTenant())));
        this.save(member);
        return this.translateResponse(member);
    }

    public Member save(Member member) {
        return (Member)this.memberRepository.save((Object)member);
    }

    private List<Member> saveAll(Iterable<Member> members) {
        return this.memberRepository.saveAll(members);
    }

    private MemberResponse translateResponse(Member member) {
        MemberResponse memberResponse = MemberMapper.INSTANCE.entityToResponse(member);
        OrganizationRoleEnum role = member.getRole(Long.valueOf(Long.parseLong(TenantContext.getCurrentTenant())));
        memberResponse.setRole(role == null ? null : role.name());
        return memberResponse;
    }

    private List<Member> newMembers(Long organizationId, MemberCreateRequest createRequest, MemberStatusEnum memberStatusEnum) {
        return createRequest.getAccounts().stream().filter(account -> this.memberIncludeDeletedService.validateAccountIncludeDeleted((String)account)).map(account -> this.newMember(organizationId, (String)account, createRequest, memberStatusEnum)).collect(Collectors.toList());
    }

    private Member newMember(Long organizationId, String account, MemberCreateRequest createRequest, MemberStatusEnum memberStatusEnum) {
        Member member = new Member();
        member.setAccount(account);
        member.setStatus(memberStatusEnum);
        member.setSource(createRequest.getSource());
        member.setPassword(new BCryptPasswordEncoder().encode((CharSequence)createRequest.getPassword()));
        Organization organization = (Organization)this.organizationRepository.findById((Object)organizationId).get();
        boolean valid = memberStatusEnum == MemberStatusEnum.ACTIVE;
        member.addOrganization(organization, createRequest.getRole(), valid);
        return member;
    }

    private void verifyPassword(String oldPassword, String newPassword) {
        if (!passwordEncoder.matches((CharSequence)oldPassword, newPassword)) {
            throw new IllegalArgumentException("validate.invalid_old_password");
        }
    }

    public Optional<Member> findByAccount(String account) {
        IEncryptionService encryptionService = (IEncryptionService)SpringBeanManager.getBeanByName((String)this.encryptionName);
        account = encryptionService.encrypt(account);
        return this.memberRepository.findByAccount(account);
    }

    public Optional<Member> findById(Long memberId) {
        return this.memberRepository.findById((Object)memberId);
    }

    public boolean existsByAccount(String account) {
        IEncryptionService encryptionService = (IEncryptionService)SpringBeanManager.getBeanByName((String)this.encryptionName);
        account = encryptionService.encrypt(account);
        return this.memberRepository.existsByAccount(account);
    }

    private void verifyAdminPrivileges() {
        if (!TokenHelper.isOwner()) {
            throw new ForbiddenException();
        }
    }

    public Page<MemberItemResponse> list(MemberSearchRequest searchRequest) {
        Pageable pageable = PageRequestUtil.toPageable((PaginationRequest)searchRequest, (Sort.Direction)Sort.Direction.DESC, (String)"createdTime");
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("organization").get("id"), (Object)TenantContext.getCurrentOrganization().getOrganizationId());
            Predicate p2 = cb.notEqual((Expression)root.get("member").get("source"), (Object)MemberSourceEnum.ACCESS_TOKEN.name());
            return query.where((Expression)cb.and((Expression)p1, (Expression)p2)).getRestriction();
        };
        Page organizationMembers = this.organizationMemberRepository.findAll((Specification)spec, pageable);
        List memberIds = organizationMembers.getContent().stream().map(organizationMember -> organizationMember.getMember().getId()).collect(Collectors.toList());
        Map<Long, Member> idToMember = this.memberRepository.findAllById(memberIds).stream().collect(Collectors.toMap(AbstractAuditEntity::getId, Function.identity()));
        return this.convertToResponse(this.getOwnerTotalCount(), TokenHelper.isOwner(), (Page<OrganizationMember>)organizationMembers, idToMember);
    }

    private long getOwnerTotalCount() {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            Predicate p1 = cb.equal((Expression)root.get("organization").get("id"), (Object)TenantContext.getCurrentOrganization().getOrganizationId());
            Predicate p2 = cb.equal((Expression)root.get("role"), (Object)OrganizationRoleEnum.OWNER);
            return query.where((Expression)cb.and((Expression)p1, (Expression)p2)).getRestriction();
        };
        return this.organizationMemberRepository.count((Specification)spec);
    }

    private Page<MemberItemResponse> convertToResponse(long ownerCount, boolean currentIsOwner, Page<OrganizationMember> organizationMembers, Map<Long, Member> idToMember) {
        return organizationMembers.map(item -> {
            MemberItemResponse response = MemberMapper.INSTANCE.entityToItemResponse((Member)idToMember.get(item.getMember().getId()));
            response.setVisitedTime(item.getLoginTime());
            if (item.getRole() == null) {
                response.setAllowEdit(false);
                return response;
            }
            response.setRole(item.getRole().name());
            boolean allowEdit = currentIsOwner;
            if (allowEdit && item.getRole().isOwner() && ownerCount == 1L) {
                allowEdit = false;
            }
            response.setAllowEdit(allowEdit);
            response.setValid(item.getValid());
            response.setOrganizationMemberCreateBy(item.getCreatedBy().getAccount());
            return response;
        });
    }

    public MemberItemResponse queryByAccount(String account) {
        Member member = this.findMemberByAccount(account, true);
        return MemberMapper.INSTANCE.entityToItemResponse(member);
    }

    private Member findLoggedInMember() {
        return this.findMemberByAccount(TokenHelper.getAccount());
    }

    private Member findMemberByAccount(String account) {
        return this.findMemberByAccount(account, false);
    }

    private Member findMemberByAccount(String account, boolean includeDeleted) {
        IEncryptionService encryptionService = (IEncryptionService)SpringBeanManager.getBeanByName((String)this.encryptionName);
        account = encryptionService.encrypt(account);
        Optional member = includeDeleted ? this.memberIncludeDeletedService.queryMemberByAccountIncludeDeleted(account) : this.memberRepository.findByAccount(account);
        String finalAccount = account;
        return (Member)member.orElseThrow(() -> new ResourceNotFoundException(ResourceType.MEMBER, finalAccount));
    }

    public void updateLoginTime(Member member, Long organizationId) {
        member.getOrganizationMembers().forEach(organizationMember -> {
            if (organizationId == organizationMember.getOrganization().getId()) {
                organizationMember.setLoginTime(new Date());
            }
        });
        this.memberRepository.save((Object)member);
    }

    @Generated
    public MemberService(MemberRepository memberRepository, MemberIncludeDeletedService memberIncludeDeletedService, OrganizationRepository organizationRepository, OrganizationMemberRepository organizationMemberRepository, EntityManager entityManager) {
        this.memberRepository = memberRepository;
        this.memberIncludeDeletedService = memberIncludeDeletedService;
        this.organizationRepository = organizationRepository;
        this.organizationMemberRepository = organizationMemberRepository;
        this.entityManager = entityManager;
    }

    @Generated
    public MemberRepository getMemberRepository() {
        return this.memberRepository;
    }

    @Generated
    public MemberIncludeDeletedService getMemberIncludeDeletedService() {
        return this.memberIncludeDeletedService;
    }

    @Generated
    public OrganizationRepository getOrganizationRepository() {
        return this.organizationRepository;
    }

    @Generated
    public OrganizationMemberRepository getOrganizationMemberRepository() {
        return this.organizationMemberRepository;
    }

    @Generated
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Generated
    public String getEncryptionName() {
        return this.encryptionName;
    }

    @Generated
    public void setEncryptionName(String encryptionName) {
        this.encryptionName = encryptionName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberService)) {
            return false;
        }
        MemberService other = (MemberService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MemberRepository this$memberRepository = this.getMemberRepository();
        MemberRepository other$memberRepository = other.getMemberRepository();
        if (this$memberRepository == null ? other$memberRepository != null : !this$memberRepository.equals(other$memberRepository)) {
            return false;
        }
        MemberIncludeDeletedService this$memberIncludeDeletedService = this.getMemberIncludeDeletedService();
        MemberIncludeDeletedService other$memberIncludeDeletedService = other.getMemberIncludeDeletedService();
        if (this$memberIncludeDeletedService == null ? other$memberIncludeDeletedService != null : !this$memberIncludeDeletedService.equals(other$memberIncludeDeletedService)) {
            return false;
        }
        OrganizationRepository this$organizationRepository = this.getOrganizationRepository();
        OrganizationRepository other$organizationRepository = other.getOrganizationRepository();
        if (this$organizationRepository == null ? other$organizationRepository != null : !this$organizationRepository.equals(other$organizationRepository)) {
            return false;
        }
        OrganizationMemberRepository this$organizationMemberRepository = this.getOrganizationMemberRepository();
        OrganizationMemberRepository other$organizationMemberRepository = other.getOrganizationMemberRepository();
        if (this$organizationMemberRepository == null ? other$organizationMemberRepository != null : !this$organizationMemberRepository.equals(other$organizationMemberRepository)) {
            return false;
        }
        EntityManager this$entityManager = this.getEntityManager();
        EntityManager other$entityManager = other.getEntityManager();
        if (this$entityManager == null ? other$entityManager != null : !this$entityManager.equals(other$entityManager)) {
            return false;
        }
        String this$encryptionName = this.getEncryptionName();
        String other$encryptionName = other.getEncryptionName();
        return !(this$encryptionName == null ? other$encryptionName != null : !this$encryptionName.equals(other$encryptionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MemberRepository $memberRepository = this.getMemberRepository();
        result = result * 59 + ($memberRepository == null ? 43 : $memberRepository.hashCode());
        MemberIncludeDeletedService $memberIncludeDeletedService = this.getMemberIncludeDeletedService();
        result = result * 59 + ($memberIncludeDeletedService == null ? 43 : $memberIncludeDeletedService.hashCode());
        OrganizationRepository $organizationRepository = this.getOrganizationRepository();
        result = result * 59 + ($organizationRepository == null ? 43 : $organizationRepository.hashCode());
        OrganizationMemberRepository $organizationMemberRepository = this.getOrganizationMemberRepository();
        result = result * 59 + ($organizationMemberRepository == null ? 43 : $organizationMemberRepository.hashCode());
        EntityManager $entityManager = this.getEntityManager();
        result = result * 59 + ($entityManager == null ? 43 : $entityManager.hashCode());
        String $encryptionName = this.getEncryptionName();
        result = result * 59 + ($encryptionName == null ? 43 : $encryptionName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MemberService(memberRepository=" + this.getMemberRepository() + ", memberIncludeDeletedService=" + this.getMemberIncludeDeletedService() + ", organizationRepository=" + this.getOrganizationRepository() + ", organizationMemberRepository=" + this.getOrganizationMemberRepository() + ", entityManager=" + this.getEntityManager() + ", encryptionName=" + this.getEncryptionName() + ")";
    }
}

