/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.enums.OrganizationRoleEnum;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.model.OrganizationMemberModel;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.dao.entity.Member;
import io.featureprobe.api.dao.entity.Organization;
import io.featureprobe.api.dao.entity.OrganizationMember;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.OrganizationMemberRepository;
import io.featureprobe.api.dao.repository.OrganizationRepository;
import io.featureprobe.api.dto.OrganizationResponse;
import io.featureprobe.api.dto.OrganizationUpdateRequest;
import io.featureprobe.api.mapper.OrganizationMapper;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrganizationService {
    OrganizationRepository organizationRepository;
    OrganizationMemberRepository organizationMemberRepository;

    @Transactional(rollbackFor={Throwable.class})
    public OrganizationMemberModel queryOrganizationMember(Long organizationId, Long memberId) {
        OrganizationMember organizationMember = (OrganizationMember)this.organizationMemberRepository.findByOrganizationIdAndMemberId(organizationId, memberId).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ORGANIZATION_MEMBER, organizationId + "_" + memberId));
        Organization organization = (Organization)this.organizationRepository.getById((Object)organizationId);
        return new OrganizationMemberModel(organizationId, organization.getName(), organizationMember.getRole(), organizationMember.getValid());
    }

    public List<OrganizationResponse> findByCurrentMember() {
        List organizationMembers = this.organizationMemberRepository.findByMemberId(TokenHelper.getUserId());
        List organizations = organizationMembers.stream().filter(it -> BooleanUtils.isTrue((Boolean)it.getValid())).map(OrganizationMember::getOrganization).collect(Collectors.toList());
        return organizations.stream().map(organization -> OrganizationMapper.INSTANCE.entityToResponse((Organization)organization)).collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Throwable.class})
    public OrganizationResponse update(OrganizationUpdateRequest organizationUpdateRequest) {
        Organization organization = this.getOrganization(TenantContext.getCurrentOrganization().getOrganizationId());
        organization.setName(organizationUpdateRequest.getName());
        this.organizationRepository.save((Object)organization);
        return OrganizationMapper.INSTANCE.entityToResponse(organization);
    }

    @Transactional(rollbackFor={Throwable.class})
    public void addMemberToOrganization(Long organizationId, Member member, OrganizationRoleEnum role, Boolean valid) {
        Organization organization = this.getOrganization(organizationId);
        OrganizationMember organizationMember = this.organizationMemberRepository.findByOrganizationIdAndMemberId(organizationId, member.getId()).orElse(null);
        if (organizationMember != null) {
            throw new ResourceConflictException(ResourceType.ORGANIZATION_MEMBER);
        }
        this.organizationMemberRepository.save((Object)new OrganizationMember(organization, member, role, valid, null));
    }

    private Organization getOrganization(Long id) {
        Organization organization = (Organization)this.organizationRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException(ResourceType.ORGANIZATION, String.valueOf(id)));
        return organization;
    }

    @Transactional(rollbackFor={Throwable.class})
    public Organization save(Organization organization) {
        return (Organization)this.organizationRepository.save((Object)organization);
    }

    @Generated
    public OrganizationService(OrganizationRepository organizationRepository, OrganizationMemberRepository organizationMemberRepository) {
        this.organizationRepository = organizationRepository;
        this.organizationMemberRepository = organizationMemberRepository;
    }
}

