/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.featureprobe.sdk.server.FPUser;
import com.featureprobe.sdk.server.FeatureProbe;
import io.featureprobe.api.auth.TokenHelper;
import io.featureprobe.api.base.component.SpringBeanManager;
import io.featureprobe.api.base.db.Archived;
import io.featureprobe.api.base.db.IncludeDeleted;
import io.featureprobe.api.base.enums.ChangeLogType;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.enums.SketchStatusEnum;
import io.featureprobe.api.base.enums.ValidateTypeEnum;
import io.featureprobe.api.base.util.KeyGenerateUtil;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Project;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.exception.ResourceOverflowException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.ProjectRepository;
import io.featureprobe.api.dao.repository.TargetingSketchRepository;
import io.featureprobe.api.dto.ApprovalSettings;
import io.featureprobe.api.dto.ApprovalSettingsResponse;
import io.featureprobe.api.dto.PreferenceCreateRequest;
import io.featureprobe.api.dto.ProjectCreateRequest;
import io.featureprobe.api.dto.ProjectQueryRequest;
import io.featureprobe.api.dto.ProjectResponse;
import io.featureprobe.api.dto.ProjectUpdateRequest;
import io.featureprobe.api.mapper.EnvironmentMapper;
import io.featureprobe.api.mapper.ProjectMapper;
import io.featureprobe.api.service.ChangeLogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectService.class);
    private ProjectRepository projectRepository;
    private EnvironmentRepository environmentRepository;
    private TargetingSketchRepository targetingSketchRepository;
    private ChangeLogService changeLogService;
    @PersistenceContext
    public EntityManager entityManager;
    private static final String LIMITER_TOGGLE_KEY = "FeatureProbe_project_limiter";

    @Transactional(rollbackFor={Exception.class})
    public ProjectResponse create(ProjectCreateRequest createRequest) {
        this.validateLimit();
        return ProjectMapper.INSTANCE.entityToResponse(this.createProject(createRequest));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectResponse update(String projectKey, ProjectUpdateRequest updateRequest) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        if (!StringUtils.equals((CharSequence)project.getName(), (CharSequence)updateRequest.getName())) {
            this.validateName(updateRequest.getName());
        }
        ProjectMapper.INSTANCE.mapEntity(updateRequest, project);
        return ProjectMapper.INSTANCE.entityToResponse((Project)this.projectRepository.save((Object)project));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProjectResponse delete(String projectKey) {
        Project project = (Project)this.projectRepository.findByKey(projectKey).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, projectKey));
        project.setArchived(true);
        this.archiveAllEnvironments(project.getEnvironments());
        return ProjectMapper.INSTANCE.entityToResponse((Project)this.projectRepository.save((Object)project));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ApprovalSettingsResponse> updateApprovalSettings(String projectKey, PreferenceCreateRequest createRequest) {
        Map approvalSettingsMap = createRequest.getApprovalSettings().stream().collect(Collectors.toMap(ApprovalSettings::getEnvironmentKey, Function.identity()));
        if (CollectionUtils.isNotEmpty(createRequest.getApprovalSettings())) {
            List environments = this.environmentRepository.findAllByProjectKey(projectKey);
            environments.stream().forEach(environment -> EnvironmentMapper.INSTANCE.mapEntity((ApprovalSettings)approvalSettingsMap.get(environment.getKey()), (Environment)environment));
            this.environmentRepository.saveAll((Iterable)environments);
        }
        return this.approvalSettingsList(projectKey);
    }

    public List<ApprovalSettingsResponse> approvalSettingsList(String projectKey) {
        List environments = this.environmentRepository.findAllByProjectKey(projectKey);
        List<ApprovalSettingsResponse> approvalSettingsList = environments.stream().map(environment -> EnvironmentMapper.INSTANCE.entityToApprovalSettingsResponse((Environment)environment)).collect(Collectors.toList());
        for (ApprovalSettingsResponse response : approvalSettingsList) {
            boolean locked = this.targetingSketchRepository.existsByProjectKeyAndEnvironmentKeyAndStatus(projectKey, response.getEnvironmentKey(), SketchStatusEnum.PENDING);
            response.setLocked(locked);
        }
        return approvalSettingsList;
    }

    private void archiveAllEnvironments(List<Environment> environments) {
        for (Environment environment : environments) {
            environment.setArchived(true);
            this.changeLogService.create(environment, ChangeLogType.DELETE);
        }
        this.environmentRepository.saveAll(environments);
    }

    private void validateLimit() {
        long total = this.projectRepository.count();
        FPUser user = new FPUser(String.valueOf(TokenHelper.getUserId()));
        user.with("account", TokenHelper.getAccount());
        double limitNum = ((FeatureProbe)SpringBeanManager.getBeanByType(FeatureProbe.class)).numberValue(LIMITER_TOGGLE_KEY, user, -1.0);
        if (limitNum > 0.0 && (double)total >= limitNum) {
            throw new ResourceOverflowException(ResourceType.PROJECT);
        }
    }

    private Project createProject(ProjectCreateRequest createRequest) {
        this.validateKey(createRequest.getKey());
        this.validateName(createRequest.getName());
        Project createProject = ProjectMapper.INSTANCE.requestToEntity(createRequest);
        createProject.setDeleted(false);
        List<Environment> defaultEnvs = this.createDefaultEnv(createProject);
        createProject.setEnvironments(defaultEnvs);
        Project saved = (Project)this.projectRepository.save((Object)createProject);
        for (Environment environment : saved.getEnvironments()) {
            this.changeLogService.create(environment, ChangeLogType.ADD);
        }
        return saved;
    }

    public List<ProjectResponse> list(ProjectQueryRequest queryRequest) {
        List projects = StringUtils.isNotBlank((CharSequence)queryRequest.getKeyword()) ? this.projectRepository.findAllByNameContainsIgnoreCaseOrDescriptionContainsIgnoreCase(queryRequest.getKeyword(), queryRequest.getKeyword()) : this.projectRepository.findAllByOrderByCreatedTimeDesc();
        return projects.stream().map(project -> ProjectMapper.INSTANCE.entityToResponse((Project)project)).collect(Collectors.toList());
    }

    public ProjectResponse queryByKey(String key) {
        Project project = (Project)this.projectRepository.findByKey(key).orElseThrow(() -> new ResourceNotFoundException(ResourceType.PROJECT, key));
        return ProjectMapper.INSTANCE.entityToResponse(project);
    }

    private List<Environment> createDefaultEnv(Project project) {
        ArrayList<Environment> environments = new ArrayList<Environment>();
        environments.add(this.createOnlineEnv(project));
        return environments;
    }

    private Environment createOnlineEnv(Project project) {
        Environment onlineEnv = new Environment();
        onlineEnv.setName("online");
        onlineEnv.setKey("online");
        onlineEnv.setProject(project);
        onlineEnv.setClientSdkKey(KeyGenerateUtil.getClientSdkKey());
        onlineEnv.setServerSdkKey(KeyGenerateUtil.getServerSdkKey());
        return onlineEnv;
    }

    @Archived
    @IncludeDeleted
    public void validateExists(ValidateTypeEnum type, String value) {
        switch (type) {
            case KEY: {
                this.validateKey(value);
                break;
            }
            case NAME: {
                this.validateName(value);
                break;
            }
        }
    }

    private void validateKey(String key) {
        if (this.projectRepository.existsByKey(key)) {
            throw new ResourceConflictException(ResourceType.PROJECT);
        }
    }

    private void validateName(String name) {
        if (this.projectRepository.existsByName(name)) {
            throw new ResourceConflictException(ResourceType.PROJECT);
        }
    }

    @Generated
    public ProjectService(ProjectRepository projectRepository, EnvironmentRepository environmentRepository, TargetingSketchRepository targetingSketchRepository, ChangeLogService changeLogService, EntityManager entityManager) {
        this.projectRepository = projectRepository;
        this.environmentRepository = environmentRepository;
        this.targetingSketchRepository = targetingSketchRepository;
        this.changeLogService = changeLogService;
        this.entityManager = entityManager;
    }
}

