/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.dao.entity.Tag;
import io.featureprobe.api.dao.repository.TagRepository;
import io.featureprobe.api.dto.TagRequest;
import io.featureprobe.api.dto.TagResponse;
import io.featureprobe.api.mapper.TagMapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TagService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagService.class);
    private TagRepository tagRepository;
    @PersistenceContext
    public EntityManager entityManager;

    public List<TagResponse> queryByProjectKey(String projectKey) {
        List tags = this.tagRepository.findByProjectKey(projectKey);
        return tags.stream().map(TagMapper.INSTANCE::entityToResponse).collect(Collectors.toList());
    }

    public TagResponse create(String projectKey, TagRequest tagRequest) {
        Tag tag = this.tagRepository.findByProjectKeyAndName(projectKey, tagRequest.getName());
        if (tag == null) {
            tag = TagMapper.INSTANCE.requestToEntity(tagRequest);
            tag.setProjectKey(projectKey);
            tag.setDeleted(false);
            this.tagRepository.save((Object)tag);
        }
        return TagMapper.INSTANCE.entityToResponse(tag);
    }

    @Generated
    public TagService(TagRepository tagRepository, EntityManager entityManager) {
        this.tagRepository = tagRepository;
        this.entityManager = entityManager;
    }
}

