/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import com.google.common.collect.Lists;
import io.featureprobe.api.base.enums.SDKType;
import io.featureprobe.api.base.enums.TrafficType;
import io.featureprobe.api.base.model.TargetingContent;
import io.featureprobe.api.base.model.Variation;
import io.featureprobe.api.base.tenant.TenantContext;
import io.featureprobe.api.dao.entity.Environment;
import io.featureprobe.api.dao.entity.Targeting;
import io.featureprobe.api.dao.entity.TargetingVersion;
import io.featureprobe.api.dao.entity.Traffic;
import io.featureprobe.api.dao.entity.VariationHistory;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.TargetingRepository;
import io.featureprobe.api.dao.repository.TargetingVersionRepository;
import io.featureprobe.api.dao.repository.TrafficRepository;
import io.featureprobe.api.dao.repository.VariationHistoryRepository;
import io.featureprobe.api.dto.TrafficPoint;
import io.featureprobe.api.dto.TrafficResponse;
import io.featureprobe.api.dto.VariationAccessCounter;
import io.featureprobe.api.mapper.TargetingVersionMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TrafficChartService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficChartService.class);
    private static final ExecutorService taskExecutor = new ThreadPoolExecutor(3, 50, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000));
    private EnvironmentRepository environmentRepository;
    private TrafficRepository trafficRepository;
    private VariationHistoryRepository variationHistoryRepository;
    private TargetingVersionRepository targetingVersionRepository;
    private TargetingRepository targetingRepository;
    @PersistenceContext
    public EntityManager entityManager;
    private static final int MAX_QUERY_HOURS = 288;
    private static final int MAX_QUERY_POINT_COUNT = 12;
    private static final int GROUP_BY_DAY_HOURS = 24;

    public boolean isAccess(String projectKey, String environmentKey, String toggleKey, SDKType sdkType) {
        String serverSdkKey = this.queryEnvironmentServerSdkKey(projectKey, environmentKey);
        if (sdkType == null) {
            return this.trafficRepository.existsBySdkKeyAndToggleKey(serverSdkKey, toggleKey);
        }
        return this.trafficRepository.existsBySdkKeyAndToggleKeyAndSdkType(serverSdkKey, toggleKey, sdkType.getValue());
    }

    public TrafficResponse query(String projectKey, String environmentKey, String toggleKey, TrafficType trafficType, int lastHours) {
        int queryLastHours = Math.min(lastHours, 288);
        String serverSdkKey = this.queryEnvironmentServerSdkKey(projectKey, environmentKey);
        boolean isAccess = this.trafficRepository.existsBySdkKeyAndToggleKey(serverSdkKey, toggleKey);
        if (!isAccess) {
            return new TrafficResponse(false, Collections.emptyList(), this.sortAccessCounters(Collections.emptyList()));
        }
        Targeting targeting = (Targeting)this.targetingRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey).get();
        Map<String, VariationHistory> variationVersionMap = this.buildVariationVersionMap(projectKey, environmentKey, toggleKey);
        List<TrafficPoint> trafficPoints = this.queryAccessEventPoints(serverSdkKey, toggleKey, targeting, queryLastHours);
        List<TrafficPoint> aggregatedTrafficPoints = this.aggregatePointByTrafficType(variationVersionMap, trafficPoints, trafficType);
        List<VariationAccessCounter> accessCounters = this.summaryAccessEvents(aggregatedTrafficPoints);
        this.appendLatestVariations(accessCounters, targeting, trafficType);
        return new TrafficResponse(isAccess, trafficPoints, this.sortAccessCounters(accessCounters));
    }

    private Map<String, VariationHistory> buildVariationVersionMap(String projectKey, String environmentKey, String toggleKey) {
        List variationHistories = this.variationHistoryRepository.findByProjectKeyAndEnvironmentKeyAndToggleKey(projectKey, environmentKey, toggleKey);
        return variationHistories.stream().collect(Collectors.toMap(this::toIndexValue, Function.identity()));
    }

    protected List<TrafficPoint> aggregatePointByTrafficType(Map<String, VariationHistory> variationVersionMap, List<TrafficPoint> trafficPoints, TrafficType trafficType) {
        trafficPoints.forEach(trafficPoint -> {
            List<VariationAccessCounter> variationAccessCounters = trafficPoint.getValues();
            List<VariationAccessCounter> filteredVariationAccessCounters = variationAccessCounters.stream().filter(variationAccessCounter -> Objects.nonNull(variationVersionMap.get(variationAccessCounter.getValue()))).collect(Collectors.toList());
            filteredVariationAccessCounters.stream().forEach(variationAccessCounter -> {
                VariationHistory variationHistory = (VariationHistory)variationVersionMap.get(variationAccessCounter.getValue());
                variationAccessCounter.setValue(trafficType.isNameType() ? variationHistory.getName() : variationHistory.getValue());
            });
            trafficPoint.setValues(filteredVariationAccessCounters);
            Map<String, Long> variationCounts = trafficPoint.getValues().stream().collect(Collectors.toMap(VariationAccessCounter::getValue, VariationAccessCounter::getCount, Long::sum));
            List<VariationAccessCounter> values = variationCounts.entrySet().stream().map(e -> new VariationAccessCounter((String)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
            trafficPoint.setValues(values);
        });
        return trafficPoints;
    }

    private List<TrafficPoint> queryAccessEventPoints(String serverSdkKey, String toggleKey, Targeting targeting, int lastHours) {
        int pointIntervalCount = this.getPointIntervalCount(lastHours);
        int pointCount = lastHours / pointIntervalCount;
        LocalDateTime pointStartTime = this.getQueryStartDateTime(lastHours);
        String pointNameFormat = this.getPointNameFormat(lastHours);
        List events = this.trafficRepository.findBySdkKeyAndToggleKeyAndStartDateGreaterThanEqualAndEndDateLessThanEqual(serverSdkKey, toggleKey, this.toDate(pointStartTime), this.toDate(pointStartTime.plusHours((long)pointIntervalCount * (long)pointCount)));
        List<TargetingVersion> versions = this.queryAllTargetingVersion(targeting, pointStartTime, pointStartTime.plusHours((long)pointIntervalCount * (long)pointCount), Long.parseLong(TenantContext.getCurrentTenant()));
        List<TrafficPoint> trafficPoints = Collections.synchronizedList(new ArrayList());
        CountDownLatch counter = new CountDownLatch(pointCount);
        for (int i = 1; i <= pointCount; ++i) {
            LocalDateTime pointEndTime = pointStartTime.plusHours(pointIntervalCount);
            AccessEventPointFilterTask task = new AccessEventPointFilterTask(events, versions, pointStartTime, pointEndTime, pointNameFormat, targeting, trafficPoints, i, Long.parseLong(TenantContext.getCurrentTenant()), counter);
            taskExecutor.submit(task);
            pointStartTime = pointEndTime;
        }
        try {
            counter.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("System error", (Throwable)e);
        }
        return trafficPoints.stream().sorted(Comparator.comparing(TrafficPoint::getSorted)).collect(Collectors.toList());
    }

    protected int getPointIntervalCount(int lastHours) {
        int pointIntervalCount = this.isGroupByDay(lastHours) ? 24 : (lastHours <= 12 ? 1 : 2);
        return pointIntervalCount;
    }

    private List<TargetingVersion> queryAllTargetingVersion(Targeting targeting, LocalDateTime pointStartTime, LocalDateTime pointEndTime, Long tenantId) {
        Specification<TargetingVersion> spec = this.buildVersionQuerySpec(targeting, pointStartTime, pointEndTime, tenantId);
        return this.targetingVersionRepository.findAll(spec);
    }

    private Specification<TargetingVersion> buildVersionQuerySpec(Targeting targeting, LocalDateTime pointStartTime, LocalDateTime pointEndTime, Long tenantId) {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate p0 = cb.equal((Expression)root.get("projectKey"), (Object)targeting.getProjectKey());
            Predicate p1 = cb.equal((Expression)root.get("environmentKey"), (Object)targeting.getEnvironmentKey());
            Predicate p2 = cb.equal((Expression)root.get("toggleKey"), (Object)targeting.getToggleKey());
            Predicate p3 = cb.equal((Expression)root.get("organizationId"), (Object)tenantId);
            Predicate p4 = cb.greaterThanOrEqualTo((Expression)root.get("createdTime"), (Comparable)this.toDate(pointStartTime));
            Predicate p5 = cb.lessThanOrEqualTo((Expression)root.get("createdTime"), (Comparable)this.toDate(pointEndTime));
            query.where((Expression)cb.and(new Predicate[]{p0, p1, p2, p3, p4, p5})).orderBy(new Order[]{cb.desc((Expression)root.get("version"))});
            return query.getRestriction();
        };
    }

    protected List<VariationAccessCounter> toAccessEvent(List<Traffic> events) {
        if (CollectionUtils.isEmpty(events)) {
            return Collections.emptyList();
        }
        Map<String, Long> variationCounts = events.stream().collect(Collectors.toMap(this::toIndexValue, Traffic::getCount, Long::sum));
        return variationCounts.entrySet().stream().map(e -> new VariationAccessCounter((String)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    private String toIndexValue(Traffic event) {
        return event.getToggleVersion() + "_" + event.getValueIndex();
    }

    private String toIndexValue(VariationHistory variationHistory) {
        return variationHistory.getToggleVersion() + "_" + variationHistory.getValueIndex();
    }

    protected String getPointNameFormat(int lastHours) {
        return this.isGroupByDay(lastHours) ? "MM/dd" : "HH";
    }

    protected LocalDateTime getQueryStartDateTime(LocalDateTime nowDateTime, int queryLastHours) {
        nowDateTime = this.isGroupByDay(queryLastHours) ? nowDateTime.withHour(23).withMinute(59).withSecond(59).withNano(0) : nowDateTime.withMinute(0).withSecond(0).withNano(0).plusHours(1L);
        return nowDateTime.minusHours(queryLastHours);
    }

    private LocalDateTime getQueryStartDateTime(int queryLastHours) {
        return this.getQueryStartDateTime(LocalDateTime.now(), queryLastHours);
    }

    protected List<VariationAccessCounter> summaryAccessEvents(List<TrafficPoint> trafficPoints) {
        ArrayList summaryEvents = Lists.newArrayList();
        trafficPoints.forEach(trafficPoint -> {
            Map<String, Long> variationCount = trafficPoint.getValues().stream().collect(Collectors.toMap(VariationAccessCounter::getValue, VariationAccessCounter::getCount));
            variationCount.keySet().forEach(key -> {
                VariationAccessCounter findingToggleCounter = summaryEvents.stream().filter(toggleCounter -> StringUtils.equals((CharSequence)toggleCounter.getValue(), (CharSequence)key)).findFirst().orElse(null);
                if (findingToggleCounter == null) {
                    summaryEvents.add(new VariationAccessCounter((String)key, (Long)variationCount.get(key)));
                } else {
                    findingToggleCounter.setCount(findingToggleCounter.getCount() + (Long)variationCount.get(key));
                }
            });
        });
        return summaryEvents;
    }

    protected void appendLatestVariations(List<VariationAccessCounter> accessCounters, Targeting latestTargeting, TrafficType trafficType) {
        TargetingContent targetingContent = TargetingVersionMapper.INSTANCE.toTargetingContent(latestTargeting.getContent());
        if (CollectionUtils.isEmpty((Collection)targetingContent.getVariations())) {
            return;
        }
        List<String> latestVariations = targetingContent.getVariations().stream().map(trafficType.isNameType() ? Variation::getName : Variation::getValue).collect(Collectors.toList());
        this.setVariationDeletedIfNotInLatest(accessCounters, latestVariations);
        this.appendVariationIfInLatest(accessCounters, latestVariations);
    }

    private void setVariationDeletedIfNotInLatest(List<VariationAccessCounter> accessCounters, List<String> namesOrValues) {
        accessCounters.stream().forEach(accessCounter -> accessCounter.setDeleted(!namesOrValues.contains(accessCounter.getValue())));
    }

    private void appendVariationIfInLatest(List<VariationAccessCounter> accessCounters, List<String> namesOrValues) {
        namesOrValues.forEach(value -> {
            if (!accessCounters.stream().filter(accessCounter -> StringUtils.equals((CharSequence)accessCounter.getValue(), (CharSequence)value)).findFirst().isPresent()) {
                accessCounters.add(new VariationAccessCounter((String)value, 0L));
            }
        });
    }

    protected List<VariationAccessCounter> sortAccessCounters(List<VariationAccessCounter> accessCounters) {
        Collections.sort(accessCounters, Comparator.comparingLong(VariationAccessCounter::getCount).reversed());
        ArrayList deletedCounters = Lists.newArrayList();
        new ArrayList<VariationAccessCounter>(accessCounters).forEach(accessCounter -> {
            if (BooleanUtils.isTrue((Boolean)accessCounter.getDeleted())) {
                deletedCounters.add(accessCounter);
                accessCounters.remove(accessCounter);
            }
        });
        accessCounters.addAll(deletedCounters);
        return accessCounters;
    }

    private String queryEnvironmentServerSdkKey(String projectKey, String environmentKey) {
        Environment environment = (Environment)this.environmentRepository.findByProjectKeyAndKey(projectKey, environmentKey).get();
        return environment.getServerSdkKey();
    }

    protected boolean isGroupByDay(int queryLastHours) {
        return queryLastHours > 24;
    }

    private Date toDate(LocalDateTime pointStartTime) {
        return Date.from(pointStartTime.atZone(TimeZone.getDefault().toZoneId()).toInstant());
    }

    @Generated
    public TrafficChartService(EnvironmentRepository environmentRepository, TrafficRepository trafficRepository, VariationHistoryRepository variationHistoryRepository, TargetingVersionRepository targetingVersionRepository, TargetingRepository targetingRepository, EntityManager entityManager) {
        this.environmentRepository = environmentRepository;
        this.trafficRepository = trafficRepository;
        this.variationHistoryRepository = variationHistoryRepository;
        this.targetingVersionRepository = targetingVersionRepository;
        this.targetingRepository = targetingRepository;
        this.entityManager = entityManager;
    }

    class AccessEventPointFilterTask
    implements Runnable {
        List<Traffic> pointEvents;
        List<TargetingVersion> versions;
        LocalDateTime pointStartTime;
        LocalDateTime pointEndTime;
        String pointNameFormat;
        Targeting targeting;
        List<TrafficPoint> trafficPoints;
        Integer sorted;
        Long tenantId;
        CountDownLatch counter;

        public AccessEventPointFilterTask(List<Traffic> pointEvents, List<TargetingVersion> versions, LocalDateTime pointStartTime, LocalDateTime pointEndTime, String pointNameFormat, Targeting targeting, List<TrafficPoint> trafficPoints, Integer sorted, Long tenantId, CountDownLatch counter) {
            this.pointEvents = pointEvents;
            this.versions = versions;
            this.pointStartTime = pointStartTime;
            this.pointEndTime = pointEndTime;
            this.pointNameFormat = pointNameFormat;
            this.targeting = targeting;
            this.trafficPoints = trafficPoints;
            this.sorted = sorted;
            this.tenantId = tenantId;
            this.counter = counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List<Traffic> currentPointEvents = this.pointEvents.stream().filter(event -> event.getStartDate().getTime() >= TrafficChartService.this.toDate(this.pointStartTime).getTime() && event.getEndDate().getTime() <= TrafficChartService.this.toDate(this.pointEndTime).getTime()).collect(Collectors.toList());
                List versionList = this.versions.stream().filter(version -> version.getCreatedTime().getTime() >= TrafficChartService.this.toDate(this.pointStartTime).getTime() && version.getCreatedTime().getTime() <= TrafficChartService.this.toDate(this.pointEndTime).getTime()).sorted(Comparator.comparing(TargetingVersion::getVersion)).collect(Collectors.toList());
                List<VariationAccessCounter> accessEvents = TrafficChartService.this.toAccessEvent(currentPointEvents);
                String pointName = String.format("%s", this.pointEndTime.format(DateTimeFormatter.ofPattern(this.pointNameFormat)));
                Long lastTargetingVersion = CollectionUtils.isEmpty(versionList) ? null : ((TargetingVersion)versionList.get(versionList.size() - 1)).getVersion();
                this.trafficPoints.add(new TrafficPoint(pointName, accessEvents, lastTargetingVersion, this.sorted));
            }
            catch (Exception e) {
                log.error("Query AccessEventPoint Task Exception.", (Throwable)e);
            }
            finally {
                this.counter.countDown();
            }
        }
    }
}

