/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.service;

import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.base.hook.CallbackType;
import io.featureprobe.api.base.model.PaginationRequest;
import io.featureprobe.api.dao.entity.WebHookSettings;
import io.featureprobe.api.dao.exception.ResourceConflictException;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.WebHookSettingsRepository;
import io.featureprobe.api.dao.utils.PageRequestUtil;
import io.featureprobe.api.dto.SecretKeyResponse;
import io.featureprobe.api.dto.WebHookCreateRequest;
import io.featureprobe.api.dto.WebHookItemResponse;
import io.featureprobe.api.dto.WebHookListRequest;
import io.featureprobe.api.dto.WebHookResponse;
import io.featureprobe.api.dto.WebHookUpdateRequest;
import io.featureprobe.api.mapper.WebHookMapper;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebHookService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebHookService.class);
    private WebHookSettingsRepository webHookSettingsRepository;
    @PersistenceContext
    public EntityManager entityManager;

    @Transactional(rollbackFor={Exception.class})
    public WebHookResponse create(WebHookCreateRequest createRequest) {
        this.checkName(createRequest.getName());
        this.checkUrl(createRequest.getUrl());
        WebHookSettings webHookSettings = WebHookMapper.INSTANCE.requestToEntity(createRequest);
        webHookSettings.setType(CallbackType.COMMON);
        return WebHookMapper.INSTANCE.entityToResponse((WebHookSettings)this.webHookSettingsRepository.save((Object)webHookSettings));
    }

    @Transactional(rollbackFor={Exception.class})
    public WebHookResponse update(Long id, WebHookUpdateRequest updateRequest) {
        WebHookSettings webHookSettings = (WebHookSettings)this.webHookSettingsRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException(ResourceType.WEBHOOK, String.valueOf(id)));
        if (!webHookSettings.getName().equals(updateRequest.getName())) {
            this.checkName(updateRequest.getName());
        }
        this.checkUrl(updateRequest.getUrl());
        WebHookMapper.INSTANCE.mapEntity(updateRequest, webHookSettings);
        return WebHookMapper.INSTANCE.entityToResponse((WebHookSettings)this.webHookSettingsRepository.save((Object)webHookSettings));
    }

    public SecretKeyResponse secretKey() {
        return new SecretKeyResponse(DigestUtils.sha1Hex((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)));
    }

    @Transactional(rollbackFor={Exception.class})
    public WebHookResponse delete(Long id) {
        WebHookSettings webHookSettings = (WebHookSettings)this.webHookSettingsRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException(ResourceType.WEBHOOK, String.valueOf(id)));
        this.webHookSettingsRepository.deleteById((Object)id);
        return WebHookMapper.INSTANCE.entityToResponse(webHookSettings);
    }

    public WebHookItemResponse query(Long id) {
        WebHookSettings webHookSettings = (WebHookSettings)this.webHookSettingsRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException(ResourceType.WEBHOOK, String.valueOf(id)));
        return WebHookMapper.INSTANCE.entityToItemResponse(webHookSettings);
    }

    public List<String> queryByUrl(String url) {
        List webHookSettingsList = this.webHookSettingsRepository.findByUrl(url);
        return webHookSettingsList.stream().map(WebHookSettings::getName).collect(Collectors.toList());
    }

    public Page<WebHookItemResponse> list(WebHookListRequest listRequest) {
        Specification & Serializable resultSpec = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicateListOr = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)listRequest.getNameLike())) {
                predicateListOr.add(cb.like((Expression)root.get("name"), "%" + listRequest.getNameLike() + "%"));
            }
            if (Objects.nonNull(listRequest.getStatus())) {
                predicateListOr.add(cb.equal((Expression)root.get("status"), (Object)listRequest.getStatus()));
            }
            if (predicateListOr.size() > 0) {
                return query.where((Expression)cb.or(predicateListOr.toArray(new Predicate[predicateListOr.size()]))).getRestriction();
            }
            return query.getRestriction();
        };
        Pageable pageable = PageRequestUtil.toPageable((PaginationRequest)listRequest, (Sort.Direction)Sort.Direction.DESC, (String)"createdTime");
        Page all = this.webHookSettingsRepository.findAll((Specification)resultSpec, pageable);
        return all.map(entity -> WebHookMapper.INSTANCE.entityToItemResponse((WebHookSettings)entity));
    }

    private void checkName(String name) {
        Optional webHookSettings = this.webHookSettingsRepository.findByName(name);
        if (webHookSettings.isPresent()) {
            throw new ResourceConflictException(ResourceType.PROJECT);
        }
    }

    private void checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("WebHook URL is illegal");
        }
    }

    @Generated
    public WebHookService(WebHookSettingsRepository webHookSettingsRepository, EntityManager entityManager) {
        this.webHookSettingsRepository = webHookSettingsRepository;
        this.entityManager = entityManager;
    }
}

