/*
 * Decompiled with CFR 0.152.
 */
package io.featureprobe.api.validate;

import com.google.common.collect.Lists;
import io.featureprobe.api.base.enums.ResourceType;
import io.featureprobe.api.dao.exception.ResourceNotFoundException;
import io.featureprobe.api.dao.repository.EnvironmentRepository;
import io.featureprobe.api.dao.repository.ProjectRepository;
import io.featureprobe.api.dao.repository.SegmentRepository;
import io.featureprobe.api.dao.repository.ToggleRepository;
import io.featureprobe.api.validate.ResourceExistsValidate;
import io.featureprobe.api.validate.ResourceKey;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

@Aspect
@Component
public class ResourceExistsValidateAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceExistsValidateAspect.class);
    ProjectRepository projectRepository;
    ToggleRepository toggleRepository;
    EnvironmentRepository environmentRepository;
    SegmentRepository segmentRepository;

    @Around(value="@within(resourceExistsValidate)")
    public Object validate(ProceedingJoinPoint joinPoint, ResourceExistsValidate resourceExistsValidate) throws Throwable {
        if (joinPoint.getSignature() instanceof MethodSignature) {
            this.validateResourceKeyExists(joinPoint);
        }
        return joinPoint.proceed();
    }

    private void validateResourceKeyExists(ProceedingJoinPoint joinPoint) {
        List<ResourceKey> resourceKeys = this.parseResourceKeys(joinPoint);
        if (resourceKeys.isEmpty()) {
            return;
        }
        this.validateResourceKeyExists(resourceKeys);
    }

    protected void validateResourceKeyExists(List<ResourceKey> resourceKeys) {
        ResourceKey projectKey = this.filterFirstResourceKey(resourceKeys, ResourceKey::isProject);
        if (projectKey == null) {
            return;
        }
        this.validateProjectExists(projectKey);
        this.validateToggleExists(projectKey, resourceKeys);
        this.validateEnvironmentExists(projectKey, resourceKeys);
        this.validateSegmentExists(projectKey, resourceKeys);
    }

    protected void validateProjectExists(ResourceKey projectKey) {
        if (projectKey == null || StringUtils.isBlank((CharSequence)projectKey.key)) {
            return;
        }
        if (!this.projectRepository.existsByKey(projectKey.key)) {
            this.throwResourceNotFoundException(projectKey);
        }
    }

    protected void validateEnvironmentExists(ResourceKey projectKey, List<ResourceKey> resourceKeys) {
        ResourceKey environmentKey = this.filterFirstResourceKey(resourceKeys, ResourceKey::isEnvironment);
        if (environmentKey == null) {
            return;
        }
        if (!this.environmentRepository.existsByProjectKeyAndKey(projectKey.key, environmentKey.getKey())) {
            this.throwResourceNotFoundException(environmentKey);
        }
    }

    protected void validateToggleExists(ResourceKey projectKey, List<ResourceKey> resourceKeys) {
        ResourceKey toggleKey = this.filterFirstResourceKey(resourceKeys, ResourceKey::isToggle);
        if (toggleKey == null) {
            return;
        }
        if (!this.toggleRepository.existsByProjectKeyAndKey(projectKey.key, toggleKey.getKey())) {
            this.throwResourceNotFoundException(toggleKey);
        }
    }

    protected void validateSegmentExists(ResourceKey projectKey, List<ResourceKey> resourceKeys) {
        ResourceKey segmentKey = this.filterFirstResourceKey(resourceKeys, ResourceKey::isSegment);
        if (segmentKey == null) {
            return;
        }
        if (!this.segmentRepository.existsByProjectKeyAndKey(projectKey.key, segmentKey.getKey())) {
            this.throwResourceNotFoundException(segmentKey);
        }
    }

    private ResourceKey filterFirstResourceKey(List<ResourceKey> resourceKeys, Predicate<ResourceKey> filter) {
        ResourceKey resourceKey = resourceKeys.stream().filter(filter).findFirst().orElse(null);
        if (resourceKey == null || StringUtils.isBlank((CharSequence)resourceKey.key)) {
            return null;
        }
        return resourceKey;
    }

    protected List<ResourceKey> parseResourceKeys(ProceedingJoinPoint joinPoint) {
        ArrayList resourceKeys = Lists.newArrayList();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] methodArgs = joinPoint.getArgs();
        Parameter[] parameters = signature.getMethod().getParameters();
        IntStream.range(0, parameters.length).forEach(index -> {
            ResourceKey resourceKey = this.parseResourceKey(methodArgs, parameters, index);
            if (resourceKey != null) {
                resourceKeys.add(resourceKey);
            }
        });
        return resourceKeys;
    }

    private ResourceKey parseResourceKey(Object[] methodArgs, Parameter[] parameters, int index) {
        PathVariable pathVariable = parameters[index].getAnnotation(PathVariable.class);
        String paramName = pathVariable != null ? pathVariable.name() : parameters[index].getName();
        ResourceType resourceType = ResourceType.of((String)paramName);
        if (resourceType == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)paramName, (CharSequence)resourceType.getParamName())) {
            return new ResourceKey(resourceType, String.valueOf(methodArgs[index]));
        }
        return null;
    }

    private void throwResourceNotFoundException(ResourceKey resourceKey) {
        throw new ResourceNotFoundException(resourceKey.type, resourceKey.getKey());
    }

    @Generated
    public ResourceExistsValidateAspect(ProjectRepository projectRepository, ToggleRepository toggleRepository, EnvironmentRepository environmentRepository, SegmentRepository segmentRepository) {
        this.projectRepository = projectRepository;
        this.toggleRepository = toggleRepository;
        this.environmentRepository = environmentRepository;
        this.segmentRepository = segmentRepository;
    }
}

